% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/qp_solvers.R
\docType{class}
\name{OSQP-class}
\alias{OSQP-class}
\alias{OSQP}
\alias{status_map,OSQP-method}
\alias{name,OSQP-method}
\alias{import_solver,OSQP-method}
\alias{invert,OSQP,list,InverseData-method}
\alias{solve_via_data,OSQP-method}
\title{An interface for the OSQP solver.}
\usage{
OSQP()

\S4method{status_map}{OSQP}(solver, status)

\S4method{name}{OSQP}(x)

\S4method{import_solver}{OSQP}(solver)

\S4method{invert}{OSQP,list,InverseData}(object, solution, inverse_data)

\S4method{solve_via_data}{OSQP}(
  object,
  data,
  warm_start,
  verbose,
  feastol,
  reltol,
  abstol,
  num_iter,
  solver_opts,
  solver_cache
)
}
\arguments{
\item{solver, object, x}{A \linkS4class{OSQP} object.}

\item{status}{A status code returned by the solver.}

\item{solution}{The raw solution returned by the solver.}

\item{inverse_data}{A \linkS4class{InverseData} object containing data necessary for the inversion.}

\item{data}{Data generated via an apply call.}

\item{warm_start}{A boolean of whether to warm start the solver.}

\item{verbose}{A boolean of whether to enable solver verbosity.}

\item{feastol}{The feasible tolerance.}

\item{reltol}{The relative tolerance.}

\item{abstol}{The absolute tolerance.}

\item{num_iter}{The maximum number of iterations.}

\item{solver_opts}{A list of Solver specific options}

\item{solver_cache}{Cache for the solver.}
}
\description{
An interface for the OSQP solver.
}
\section{Methods (by generic)}{
\itemize{
\item \code{status_map}: Converts status returned by the OSQP solver to its respective CVXPY status.

\item \code{name}: Returns the name of the solver.

\item \code{import_solver}: Imports the solver.

\item \code{invert}: Returns the solution to the original problem given the inverse_data.

\item \code{solve_via_data}: Solve a problem represented by data returned from apply.
}}

