% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/exports.R
\docType{methods}
\name{mixed_norm}
\alias{mixed_norm}
\title{Mixed Norm}
\usage{
mixed_norm(X, p = 2, q = 1)
}
\arguments{
\item{X}{An \linkS4class{Expression}, vector, or matrix.}

\item{p}{The type of inner norm.}

\item{q}{The type of outer norm.}
}
\value{
An \linkS4class{Expression} representing the \eqn{l_{p,q}} norm of the input.
}
\description{
\eqn{l_{p,q}(x) = \left(\sum_{i=1}^n (\sum_{j=1}^m |x_{i,j}|)^{q/p}\right)^{1/q}}.
}
\examples{
A <- Variable(2,2)
val <- cbind(c(3,3), c(4,4))
prob <- Problem(Minimize(mixed_norm(A,2,1)), list(A == val))
result <- solve(prob)
result$value
result$getValue(A)

val <- cbind(c(1,4), c(5,6))
prob <- Problem(Minimize(mixed_norm(A,1,Inf)), list(A == val))
result <- solve(prob)
result$value
result$getValue(A)
}
