% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/exports.R
\docType{methods}
\name{log,Expression-method}
\alias{log,Expression-method}
\alias{log}
\alias{log10}
\alias{log2}
\alias{log1p}
\alias{log10,Expression-method}
\alias{log2,Expression-method}
\alias{log1p,Expression-method}
\title{Logarithms}
\usage{
\S4method{log}{Expression}(x, base = base::exp(1))

\S4method{log10}{Expression}(x)

\S4method{log2}{Expression}(x)

\S4method{log1p}{Expression}(x)
}
\arguments{
\item{x}{An \linkS4class{Expression}.}

\item{base}{(Optional) A positive number that is the base with respect to which the logarithm is computed. Defaults to \eqn{e}.}
}
\value{
An \linkS4class{Expression} representing the exponentiated input.
}
\description{
The elementwise logarithm.
\code{log} computes the logarithm, by default the natural logarithm, \code{log10} computes the common (i.e., base 10) logarithm, and \code{log2} computes the binary (i.e., base 2) logarithms. The general form \code{log(x, base)} computes logarithms with base \code{base}.
\code{log1p} computes elementwise the function \eqn{\log(1+x)}.
}
\examples{
# Log in objective
x <- Variable(2)
obj <- Maximize(sum(log(x)))
constr <- list(x <= matrix(c(1, exp(1))))
prob <- Problem(obj, constr)
result <- solve(prob)
result$value
result$getValue(x)

# Log in constraint
obj <- Minimize(sum(x))
constr <- list(log2(x) >= 0, x <= matrix(c(1,1)))
prob <- Problem(obj, constr)
result <- solve(prob)
result$value
result$getValue(x)

# Index into log
obj <- Maximize(log10(x)[2])
constr <- list(x <= matrix(c(1, exp(1))))
prob <- Problem(obj, constr)
result <- solve(prob)
result$value

# Scalar log
obj <- Maximize(log1p(x[2]))
constr <- list(x <= matrix(c(1, exp(1))))
prob <- Problem(obj, constr)
result <- solve(prob)
result$value
}
