% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/atoms.R
\docType{class}
\name{EyeMinusInv-class}
\alias{EyeMinusInv-class}
\alias{.EyeMinusInv}
\alias{EyeMinusInv}
\alias{to_numeric,EyeMinusInv-method}
\alias{name,EyeMinusInv-method}
\alias{dim_from_args,EyeMinusInv-method}
\alias{sign_from_args,EyeMinusInv-method}
\alias{is_atom_convex,EyeMinusInv-method}
\alias{is_atom_concave,EyeMinusInv-method}
\alias{is_atom_log_log_convex,EyeMinusInv-method}
\alias{is_atom_log_log_concave,EyeMinusInv-method}
\alias{is_incr,EyeMinusInv-method}
\alias{is_decr,EyeMinusInv-method}
\alias{.grad,EyeMinusInv-method}
\title{The EyeMinusInv class.}
\usage{
EyeMinusInv(X)

\S4method{to_numeric}{EyeMinusInv}(object, values)

\S4method{name}{EyeMinusInv}(x)

\S4method{dim_from_args}{EyeMinusInv}(object)

\S4method{sign_from_args}{EyeMinusInv}(object)

\S4method{is_atom_convex}{EyeMinusInv}(object)

\S4method{is_atom_concave}{EyeMinusInv}(object)

\S4method{is_atom_log_log_convex}{EyeMinusInv}(object)

\S4method{is_atom_log_log_concave}{EyeMinusInv}(object)

\S4method{is_incr}{EyeMinusInv}(object, idx)

\S4method{is_decr}{EyeMinusInv}(object, idx)

\S4method{.grad}{EyeMinusInv}(object, values)
}
\arguments{
\item{X}{An \linkS4class{Expression} or numeric matrix.}

\item{object, x}{An \linkS4class{EyeMinusInv} object.}

\item{values}{A list of numeric values for the arguments}

\item{idx}{An index into the atom.}
}
\description{
This class represents the unity resolvent of an elementwise positive matrix \eqn{X}, i.e., \eqn{(I - X)^{-1}},
and it enforces the constraint that the spectral radius of \eqn{X} is at most 1.
This atom is log-log convex.
}
\section{Methods (by generic)}{
\itemize{
\item \code{to_numeric}: The unity resolvent of the matrix.

\item \code{name}: The name and arguments of the atom.

\item \code{dim_from_args}: The dimensions of the atom determined from its arguments.

\item \code{sign_from_args}: The (is positive, is negative) sign of the atom.

\item \code{is_atom_convex}: Is the atom convex?

\item \code{is_atom_concave}: Is the atom concave?

\item \code{is_atom_log_log_convex}: Is the atom log-log convex?

\item \code{is_atom_log_log_concave}: Is the atom log-log concave?

\item \code{is_incr}: Is the atom weakly increasing in the index?

\item \code{is_decr}: Is the atom weakly decreasing in the index?

\item \code{.grad}: Gives EyeMinusInv the (sub/super)gradient of the atom w.r.t. each variable
}}

\section{Slots}{

\describe{
\item{\code{X}}{An \linkS4class{Expression} or numeric matrix.}
}}

