% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/generics.R
\name{sign-methods}
\alias{sign-methods}
\alias{is_zero}
\alias{is_positive}
\alias{is_negative}
\title{Sign Properties}
\usage{
is_zero(object)

is_positive(object)

is_negative(object)
}
\arguments{
\item{object}{An \linkS4class{Expression} object.}
}
\value{
A logical value.
}
\description{
Determine if an expression is positive, negative, or zero.
}
\examples{
pos <- Constant(1)
neg <- Constant(-1)
zero <- Constant(0)
unknown <- Variable()

is_zero(pos)
is_zero(-zero)
is_zero(unknown)
is_zero(pos + neg)

is_positive(pos + zero)
is_positive(pos * neg)
is_positive(pos - neg)
is_positive(unknown)

is_negative(-pos)
is_negative(pos + neg)
is_negative(neg * zero)
is_negative(neg - pos)
}
