% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/probcubshe1.R
\name{probcubshe1}
\alias{probcubshe1}
\title{probcubshe1}
\usage{
probcubshe1(m,pai1,pai2,csi,shelter)
}
\arguments{
\item{m}{Number of ordinal categories}

\item{pai1}{Mixing coefficient for the shifted Binomial component of the mixture distribution}

\item{pai2}{Mixing coefficient for the discrete Uniform component of the mixture distribution}

\item{csi}{Feeling parameter}

\item{shelter}{Category corresponding to the shelter choice}
}
\value{
The vector of the probability distribution of an extended CUB model with a shelter effect 
at the shelter category
}
\description{
Probability distribution of an extended CUB model with a shelter effect.
}
\details{
An extended CUB model is a mixture of three components: a shifted Binomial distribution 
with probability of success \eqn{\xi}, a discrete uniform distribution with support \eqn{\{1,...,m\}},
 and a degenerate distribution with unit mass at the shelter category (\code{shelter}).
}
\examples{
m<-8
pai1<-0.5
pai2<-0.3
csi<-0.4
shelter<-6
pr<-probcubshe1(m,pai1,pai2,csi,shelter)
plot(1:m,pr,type="h",main="Extended CUB probability distribution with shelter effect",
xlab="Ordinal categories")
points(1:m,pr,pch=19)
}
\references{
Iannario M. (2012). Modelling \emph{shelter} choices in a class of mixture models for ordinal responses,  
\emph{Statistical Methods and Applications}, \bold{21}, 1--22 \cr
}
\seealso{
\code{\link{probcubshe2}}, \code{\link{probcubshe3}}
}
\keyword{distribution}
