% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/simcubshe.R
\name{simcubshe}
\alias{simcubshe}
\title{Simulation routine for CUB models with shelter effect}
\usage{
simcubshe(n,m,pai,csi,delta,shelter)
}
\arguments{
\item{n}{Number of simulated observations}

\item{m}{Number of ordinal categories}

\item{pai}{Uncertainty parameter}

\item{csi}{Feeling parameter}

\item{delta}{Shelter parameter}

\item{shelter}{Category corresponding to the shelter choice}
}
\description{
Generate \eqn{n} pseudo-random observations following the given CUB distribution
 with shelter effect.
}
\examples{
n<-300
m<-9
pai<-0.7
csi<-0.3
delta<-0.2
shelter<-3
simulation<-simcubshe(n,m,pai,csi,delta,shelter)
plot(table(simulation),xlab="Ordinal categories",ylab="Frequencies")
}
\seealso{
\code{\link{probcubshe1}}, \code{\link{probcubshe2}}, \code{\link{probcubshe3}}
}
\keyword{distribution}
