# @title Auxiliary function for the log-likelihood estimation of CUB models
# @description Compute the opposite of the scalar function that is maximized when running 
# the E-M algorithm for CUB models with covariates for the feeling parameter.
# @aliases effe01
# @usage effe01(gama, esterno01, m)
# @param gama Vector of the starting values of the parameters to be estimated
# @param esterno01 A matrix binding together the vector of the posterior probabilities
# that each observation has been generated by the first component distribution of the mixture, 
# the ordinal data and the matrix of the selected covariates accounting for an intercept term
# @details It is called as an argument for optim within CUB function for models with covariates for
# feeling or for both feeling and uncertainty
#' @keywords internal 


effe01 <-
function(gama,esterno01,m){  
  ttau<-esterno01[,1]
  ordd<-esterno01[,2]
  covar<-esterno01[,3:ncol(esterno01)]
  return(sum(ttau*((ordd-1)*(covar%*%gama)+(m-1)*log(1+exp(-covar%*%gama)))))
}
