% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/new_ctre.R
\name{ctre}
\alias{ctre}
\title{CTRE model}
\usage{
ctre(x, y = NULL, drop.duplicate.times = FALSE)
}
\arguments{
\item{x}{Either
\itemize{
  \item a \code{data.frame} with two columns, or
  \item a vector; then y must be a vector of same length, or
  \item a \code{zoo} object.
}
The first component/column must contain the event times and be
of class "numeric", "Date" or "POSIXct";
the second component/column must contain the event magnitudes and
be of type "numeric".}

\item{y}{If x is a vector, y needs to be supplied as a vector of same length.}

\item{drop.duplicate.times}{If there are duplicate time stamps present, should duplicates be
dropped?}
}
\value{
An object of class \code{'ctre'} based on a time series of
        magnitudes.
}
\description{
Creates an object of class \code{'ctre'} (Continuous Time Random
Maxima).
}
\examples{
times <- cumsum(MittagLeffleR::rml(n = 1000, tail = 0.8, scale = 5))
magnitudes <- rexp(n = 1000)
sim_ctre <- ctre(times, magnitudes)
sim_ctre
plot(sim_ctre)

library(magrittr)
bitcoin_ctre <- bitcoin \%>\% ctre() \%>\% thin(k = 400)
plot(bitcoin_ctre, log = 'y')
}
\seealso{
\link{CTRE}
}
