% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/MLestimates.R
\name{MLestimates}
\alias{MLestimates}
\title{Mittag-Leffler estimates for varying thresholds}
\usage{
MLestimates(ctre, plot_me = TRUE, tail = NULL, scale = NULL,
  ks = 5:length(ctre))
}
\arguments{
\item{ctre}{A \code{\link{ctre}} object}

\item{plot_me}{Should the estimates be plotted?}

\item{tail}{Tail parameter of the Mittag-Leffler distribution, if known.
Appears as a
dashed line in the plot of the tail parameter estimates, and
transforms the scale parameter estimates. If not known,
scale parameter estimates are untransformed (tail is set to 1).}

\item{scale}{Scale parameter of the Mittag-Leffler distribution, if known.
Appears as a dashed line in the plot of scale parameter
estimates.}

\item{ks}{The values of k at for which estimates are computed.
If e.g. k=10, then the threshold is set at the 10th order statistic
(10th largest magnitude), and Mittag-Leffler parameter estimates
are coputed for the threshold exceedance times.
By default, all order statistics are used except the 5 largest,
and the estimates are returned in a data frame.}
}
\value{
A \code{data.frame} of Mittag-Leffler parameter estimates,
        one row for each threshold, which is returned invisibly
        unless \code{plot_me = FALSE}.
}
\description{
For a range of thresholds, return the parameters of the Mittag-Leffler
distribution fitted to the threshold exceedance times.
}
\details{
If \code{plot_me = TRUE}, the estimates are returned invisibly.
}
\examples{
  library(magrittr)
  par(mfrow = c(1,2))
  flares \%>\% ctre() \%>\% thin(k=1000) \%>\% MLestimates(tail = 0.9, scale = 3E7)

  bitcoin \%>\% ctre() \%>\% thin(k=500) \%>\% MLestimates(tail = 0.9, scale = 2.5E3)
  bitcoin \%>\% ctre() \%>\% thin(k=500) \%>\% MLestimates(plot_me = FALSE) \%>\% str()
}
