% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/mle.getPtBSbyK.r
\name{mle.getPtBSbyK}
\alias{mle.getPtBSbyK}
\title{Generate patient-specific bitstrings}
\usage{
mle.getPtBSbyK(S, ranks, num.misses = NULL)
}
\arguments{
\item{S}{- A character vector of node names describing the node subset
to be encoded.}

\item{ranks}{- The list of node ranks calculated over all possible nodes,
starting with each node in subset of interest.}

\item{num.misses}{- The number of misses tolerated by the network walker
before path truncation occurs.}
}
\value{
pt.byK - a list of bitstrings, with the names of the list elements
the node names of the encoded nodes
}
\description{
This function calculates the bitstrings (1 is a hit; 0 is a miss)
associated with a network walker which tries to find all nodes in
a given subset, S, in a given network, G.
}
\examples{
# Get patient bitstrings for the first 2 patients in the Miller 2015 dataset.
data("Miller2015")
data_mx=Miller2015[-c(1,grep("x - ", rownames(Miller2015))),
                    grep("IEM", colnames(Miller2015))]
data_mx=apply(data_mx[,c(1,2)], c(1,2), as.numeric)
# Build an adjacency matrix for network G
adj_mat=matrix(0, nrow=nrow(data_mx), ncol=nrow(data_mx))
rows=sample(seq_len(ncol(adj_mat)), 0.1*ncol(adj_mat))
cols=sample(seq_len(ncol(adj_mat)), 0.1*ncol(adj_mat))
for(i in rows){for (j in cols){adj_mat[i, j]=rnorm(1,0,1)}}
colnames(adj_mat)=rownames(data_mx)
rownames(adj_mat)=rownames(data_mx)
G=vector("numeric", length=ncol(adj_mat))
names(G)=colnames(adj_mat)
# Look at the top 5 metabolites for each patient. 
kmx=5
topMets_allpts=c()
for (pt in seq_len(ncol(data_mx))) { 
    topMets_allpts=c(topMets_allpts,
                    rownames(data_mx)[order(abs(data_mx[,pt]),
                                            decreasing=TRUE)[seq_len(kmx)]])}
topMets_allpts=unique(topMets_allpts)
# Use a single-node or multi-node network walker.
# Here we use a single-node network walker.
ranks=list()
for (n in seq_len(length(topMets_allpts))) { 
    ind=which(names(G)==topMets_allpts[n])
    ranks[[n]]=singleNode.getNodeRanksN(ind,G,0.9,0.01,adj_mat,
                                        topMets_allpts,log2(length(G))) 
}
names(ranks)=topMets_allpts
ptBSbyK=list()
for (pt in seq_len(ncol(data_mx))) {
    S=rownames(data_mx)[order(abs(data_mx[,pt]),
                                decreasing=TRUE)[seq_len(kmx)]]
    ptBSbyK[[pt]]=mle.getPtBSbyK(S, ranks)
}
}
