% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/MSEver.R
\name{MSEver}
\alias{MSEver}
\title{Caculate the MSE values of the COR criterion for redundant data in simulation}
\usage{
MSEver(K = K, nk = nk, alpha = alpha, X = X, y = y)
}
\arguments{
\item{K}{is the number of subsets}

\item{nk}{is the length of subsets}

\item{alpha}{is the significance level}

\item{X}{is the observation matrix}

\item{y}{is the response vector}
}
\value{
minE,Mcor,Mx,MA
}
\description{
Caculate the MSE values of the COR criterion for redundant data in simulation
}
\examples{
 p=6;n=1000;K=2;nk=200;alpha=0.05;sigma=1
 e=rnorm(n,0,sigma); beta=c(sort(c(runif(p,0,1)))); 
 data=c(rnorm(n*p,5,10));X=matrix(data, ncol=p);
 y=X\%*\%beta+e;
 MSEver(K=K,nk=nk,alpha=alpha,X=X,y=y)
}
