% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/theta_optim_XM.R
\name{theta_optim_XM}
\alias{theta_optim_XM}
\title{Likelihood Function for Normal Outcome Mechanism with a Binary Mediator and an Interaction Term}
\usage{
theta_optim_XM(param_start, m, x, c_matrix, outcome, sample_size, n_cat)
}
\arguments{
\item{param_start}{A numeric vector or column matrix of starting values for the \eqn{\theta}
parameters in the outcome mechanism and \eqn{\sigma} parameter.
The number of elements in \code{param_start}
should be equal to the number of columns of \code{x_matrix} and \code{c_matrix} plus 2
(if \code{interaction_indicator} is \code{FALSE}) or 3 (if
\code{interaction_indicator} is \code{TRUE}). Starting values should be
provided in the following order: intercept, slope coefficient for the \code{x_matrix} term,
slope coefficient for the mediator \code{m} term,
slope coefficient for first column of the \code{c_matrix}, ...,
slope coefficient for the final column of the \code{c_matrix},
and, optionally, slope coefficient for \code{xm}). The final entry should be
the starting value for \eqn{\sigma}.}

\item{m}{vector or column matrix containing the true binary mediator or the
E-step weight (with values between 0 and 1). There
should be no \code{NA} terms.}

\item{x}{A vector or column matrix of the predictor or exposure of interest. There
should be no \code{NA} terms.}

\item{c_matrix}{A numeric matrix of covariates in the true mediator and outcome mechanisms.
\code{c_matrix} should not contain an intercept and no values should be \code{NA}.}

\item{outcome}{A vector containing the outcome variables of interest. There
should be no \code{NA} terms.}

\item{sample_size}{An integer value specifying the number of observations in the sample.
This value should be equal to the number of rows of the design matrix, \code{X} or \code{Z}.}

\item{n_cat}{The number of categorical values that the true outcome, \code{M},
and the observed outcome, \code{M*} can take.}
}
\value{
\code{theta_optim_XM} returns a numeric value of the (negative) log-likelihood function.
}
\description{
Likelihood Function for Normal Outcome Mechanism with a Binary Mediator and an Interaction Term
}
