% Generated by roxygen2 (4.1.1): do not edit by hand
% Please edit documentation in R/COMBIA.R
\name{applyLoewe}
\alias{applyLoewe}
\title{This function calculates Loewe synergy/antagonism values and associated BIs.}
\usage{
applyLoewe(rawDataPreProcessed, xConcentration, yConcentration, nBoot)
}
\arguments{
\item{rawDataPreProcessed}{Raw preprocessed experimental data.}

\item{xConcentration}{X drug concentrations tested in an experiment.}

\item{yConcentration}{Y drug concentrations tested in an experiment.}

\item{nBoot}{Number of times to bootstrap in order  to calculate BIs.}
}
\value{
Three lists, first list containing Loewe Synergy/Antagonism, lower and upper bound of corresponding BI.
Second list consists of global BI for maximum synergy observed in the experiment and third list
contains global BI of maximum antagonism.
}
\description{
This function calculates Loewe synergy/antagonism values and associated BIs.
}
\examples{
library(gdata)
dataFile <- system.file("/raw/rawDataPreProcessed.csv", package="COMBIA")
dataSample <- read.csv(dataFile, header=FALSE )
xConc <- c(0.00,  0.20,  0.39,  0.78,  1.56,3.12,  6.25, 12.50, 25.00, 50)
yConc <- c(128,  64,  32,  16,   8,   4,   2,   0)
noOFBoot <- 50
rslt <- applyLoewe(as.matrix(dataSample), xConc, yConc, noOFBoot)
}
\author{
Muhammad kashif
}

