% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/regen.R
\name{Regen.coin}
\alias{Regen.coin}
\title{Regenerate a coin}
\usage{
\method{Regen}{coin}(x, from = NULL, quietly = TRUE, ...)
}
\arguments{
\item{x}{A coin class object}

\item{from}{Optional: a construction function name. If specified, regeneration begins from this function, rather
than re-running all functions.}

\item{quietly}{If \code{TRUE} (default), messages are suppressed during building.}

\item{...}{arguments passed to or from other methods.}
}
\value{
Updated coin object with regenerated results (data sets).
}
\description{
Regenerates the \code{.$Data} entries in a coin by rerunning the construction functions according to the specifications in \code{.$Log}.
This effectively regenerates the results. Different variations of coins can be quickly achieved by editing the
saved arguments in \code{.$Log} and regenerating.
}
\details{
The \code{from} argument allows partial regeneration, starting from a
specified function. This can be helpful to speed up regeneration in some cases. However, keep in mind that
if you change a \code{.$Log} argument from a function that is run before the point that you choose to start running
from, it will not affect the results.

Note that while sets of weights will be passed to the regenerated COIN, anything in \code{.$Analysis} will be removed
and will have to be recalculated.

See also \code{vignette("adjustments")} for more info on regeneration.
}
\examples{
# build full example coin
coin <- build_example_coin(quietly = TRUE)

# copy coin
coin2 <- coin

# change to prank function (percentile ranks)
# we don't need to specify any additional parameters (f_n_para) here
coin2$Log$Normalise$global_specs <- list(f_n = "n_prank")

# regenerate
coin2 <- Regen(coin2)

# compare index, sort by absolute rank difference
compare_coins(coin, coin2, dset = "Aggregated", iCode = "Index",
              sort_by = "Abs.diff", decreasing = TRUE)

}
