% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/check_and_get.R
\name{get_data.coin}
\alias{get_data.coin}
\title{Get subsets of indicator data}
\usage{
\method{get_data}{coin}(
  x,
  dset,
  iCodes = NULL,
  Level = NULL,
  uCodes = NULL,
  use_group = NULL,
  also_get = NULL,
  ...
)
}
\arguments{
\item{x}{A coin class object}

\item{dset}{The name of the data set to apply the function to, which should be accessible in \code{.$Data}.}

\item{iCodes}{Optional indicator codes to retrieve. If \code{NULL} (default), returns all iCodes found in
the selected data set. Can also refer to indicator groups. See details.}

\item{Level}{Optionally, the level in the hierarchy to extract data from. See details.}

\item{uCodes}{Optional unit codes to filter rows of the resulting data set. Can also be used in conjunction
with groups. See details.}

\item{use_group}{Optional group to filter rows of the data set. Specified as \code{list(Group_Var = Group)},
where \code{Group_Var} is a Group_ column that must be present in the selected data set, and \code{Group} is a specified group
inside that grouping variable. This filters the selected data to only include rows from the specified group. Can
also be used in conjunction with \code{uCodes} -- see details.}

\item{also_get}{A character vector specifying any columns to attach to the data set that are \emph{not}
indicators or aggregates. These will be e.g. \code{uName}, groups, denominators or columns labelled as "Other"
in \code{iMeta}. These columns are stored in \code{.$Meta$Unit} to avoid repetition. Set \code{also_get = "all"} to
attach all columns, or set \code{also_get = "none"} to return only numeric columns, i.e. no \code{uCode} column.}

\item{...}{arguments passed to or from other methods.}
}
\value{
A data frame of indicator data according to specifications.
}
\description{
A flexible function for retrieving data from a coin, from a specified data set. Subsets of data can
be returned based on selection of columns, using the \code{iCodes} and \code{Level} arguments, and by filtering
rowwise using the \code{uCodes} and \code{use_group} arguments. The \code{also_get} argument also allows unit metadata
columns to be attached, such as names, groups, and denominators.
}
\details{
The \code{iCodes} argument can be used to directly select named indicators, i.e. setting \code{iCodes = c("a", "b")}
will select indicators "a" and "b", attaching any extra columns specified by \code{also_get}. However,
using this in conjunction with the \code{Level} argument returns named groups of indicators. For example,
setting \code{iCodes = "Group1"} (for e.g. an aggregation group in Level 2) and \code{Level = 1} will return
all indicators in Level 1, belonging to "Group1".

Rows can also be subsetted. The \code{uCodes} argument can be used to select specified units in the same
way as \code{iCodes}. Additionally, the \code{use_group} argument filters to specified groups. If \code{uCodes} is
specified, and \code{use_group} refers to a named group column, then it will return all units in the
groups that the \code{uCodes} belong to. This is useful for putting a unit into context with its peers
based on some grouping variable.

Note that if you want to retrieve a whole data set (with no column/row subsetting), use the
\code{\link[=get_dset]{get_dset()}} function which should be slightly faster.
}
\examples{
# build full example coin
coin <- build_example_coin(up_to = "new_coin", quietly = TRUE)

# get all indicators in "Political group
x <- get_data(coin, dset = "Raw", iCodes = "Political", Level = 1)
head(x, 5)

# see vignette("data_selection") for more examples

}
