% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/coin_treat.R
\name{loggish}
\alias{loggish}
\title{Log-type transformation of a vector}
\usage{
loggish(x, ltype, params = NULL)
}
\arguments{
\item{x}{A vector or column of data to transform}

\item{ltype}{The type of log transformation - see \code{deflog} in \code{\link[=treat]{treat()}}.}

\item{params}{Some extra parameters to pass. These parameters mostly concern internal messages for \code{\link[=treat]{treat()}} and this can be
left unspecified unless \code{ltype == "boxcox"}, in which case there should be a parameter \code{params$boxlam} specified
(see \code{\link[=BoxCox]{BoxCox()}}). However, if you wish to use a Box Cox transformation, it is better to use \code{\link[=BoxCox]{BoxCox()}} directly.}
}
\value{
A list with
\itemize{
\item \code{.$x} is the transformed vector of data
\item \code{.$Flag} is a flag of the type of treatment specified (used inside \code{\link[=treat]{treat()}})
\item \code{.$Treatment} the treatment applied (used inside \code{\link[=treat]{treat()}})
\item \code{.$TreatSpec} the treatment specified (used inside \code{\link[=treat]{treat()}})
}
}
\description{
This applies various simple transformations, to be used by the \code{\link[=treat]{treat()}} function.
This function is probably not very useful on its own because it requires \code{params},
a list of parameters which are used to output the type and status of treatment applied.
}
\examples{
# get a column of data with outliers
x <- ASEMIndData$Tariff
# apply a GII transformation
xdash <- loggish(x, ltype = "GIIlog")
# plot one against the other
plot(x, xdash$x)

}
\seealso{
\itemize{
\item \code{\link[=treat]{treat()}} Outlier treatment
}
}
