% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/convrg_func.R
\name{diversity_calc}
\alias{diversity_calc}
\title{Calculate diversity entropies for each replicate}
\usage{
diversity_calc(
  model_output,
  countData,
  params = "pi",
  entropy_measure = "shannon",
  equivalents = T
)
}
\arguments{
\item{model_output}{Object from fitted 'Stan' model that has samples describing posteriors of focal parameters.}

\item{countData}{Dataframe of count data that was modelled. Should be exactly the same as those data modelled! The first field should be sample name and integer count data should be in all other fields. This is passed in so that the names of fields can be used to make the output of differential relative abundance testing more readable.}

\item{params}{Parameter for which to calculate diversity, can be 'p' or 'pi' or both (e.g., c("pi","p"))}

\item{entropy_measure}{Diversity entropy to use, can be one of 'shannon' or 'simpson'}

\item{equivalents}{Convert entropies into number equivalents. Defaults to true. See Jost (2006), "Entropy and diversity"}
}
\value{
A list that has samples from posterior distributions of entropy metrics
}
\description{
Calculate Shannon's or Simpson's entropies for each replicate while propagating uncertainty in relative abundance estimates through calculations.
}
\details{
Takes as input either a fitted Stan oject from the cnvrg_HMC or cnvrg_VI functions, or a list that is the extracted pi values from one of those objects.
It may be desirable to extract pi values from a fitted model object and transform them, e.g., via division by an ISD, before calculating diversity entropies.
So long as the input list of posterior samples follow the same format as they do within the fitted model objects, this function should perform as expected.
As always, doublecheck the results to ensure the function has output reasonable values.
}
\examples{
#simulate an OTU table
com_demo <-matrix(0, nrow = 10, ncol = 10)
com_demo[1:5,] <- c(rep(3,5), rep(7,5)) #Alternates 3 and 7
com_demo[6:10,] <- c(rep(7,5), rep(3,5)) #Reverses alternation
fornames <- NA
for(i in 1:length(com_demo[1,])){
fornames[i] <- paste("otu_", i, sep = "")
}
sample_vec <- NA
for(i in 1:length(com_demo[,1])){
sample_vec[i] <- paste("sample", i, sep = "_")
}
com_demo <- data.frame(sample_vec, com_demo)
names(com_demo) <- c("sample", fornames)

out <- cnvrg_VI(com_demo,starts = c(1,6), ends=c(5,10))
diversity_calc(model_output = out,params = c("pi","p"),
countData = com_demo, entropy_measure = 'shannon')
}
