% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/func_ARL.R
\name{ARL}
\alias{ARL}
\title{ARL Test}
\usage{
ARL(y, treatment, block1, block2)
}
\arguments{
\item{y}{a numeric vector for the response variable.}

\item{treatment}{a vector giving the treatment type for the corresponding
elements of \code{y}.}

\item{block1}{a vector giving the first blocking variable for the
corresponding elements of \code{y}.}

\item{block2}{a vector giving the second blocking variable for the
corresponding elements of \code{y}.}
}
\value{
A list containing the ARL test statistic adjusted for ties together
with the associated p-value using a chi-squared distribution with t-1 degrees
of freedom.
}
\description{
\code{ARL} returns the test statistic and p-value for the aligned RL test.
}
\details{
This test is applicable to Latin square designs. The test is not recommended
though as the use of t-1 degrees of freedom in the null distribution results
in unsatisfactorily large test sizes.

The \code{CARL} test uses t+1 degrees of freedom in the null distribution which
results is appropriate test size and good power.
}
\examples{
attach(peanuts)
ARL(y = yield, treatment = treatment, block1 = row, block2 = col)

}
\references{
Rayner, J.C.W and Livingston, G. C. (2022). An Introduction to Cochran-Mantel-Haenszel Testing and Nonparametric ANOVA. Wiley.
}
\seealso{
\code{\link[=CARL]{CARL()}} \code{\link[=PARL]{PARL()}}
}
