# These are the datasets loaded so all the example could run directly
# Those frequently used datasets shall be updated from time to time


#' UNICEF_colors load UNICEF color palette Load UNICEF blue, Sequential, Diverging,
#' Qualitative, and grays scheme into the global environment
#'
#' @docType data
#' @keywords color scheme
#' @details UNICEF_colors <- list(
#'     "UNICEF_blue" = "#1CABE2",
#'     # Sequential scheme
#'     "cp_UNICEF_seq" = c( "#002759", "#00377D", "#0058AB","#0083CF","#1CABE2","#69DBFF",
#'                          "#A3EAFF","#CFF4FF"),
#'     # Diverging scheme
#'     "cp_UNICEF_div" = c("#002759", "#0058AB", "#1CABE2", "#69DBFF", "#CFF4FF", "#FFF09C",
#'                         "#FFC20E", "#F26A21", "#E2231A", "#B50800"),
#'     # Qualitative schemes
#'     "cp_UNICEF_qua" = c("#0058AB", "#1CABE2", "#00833D", "#80BD41", "#6A1E74", "#961A49",
#'                         "#E2231A", "#F26A21", "#FFC20E", "#FFF09C"),
#'     # grays
#'     "cp_UNICEF_grays" = c("#333333", "#6B6B6B","#B3B3B3","#D7D7D7","#E8E8E8")
#'     )
"UNICEF_colors"


#'new_cnames: the official country names: ISO3Code UNCode OfficialName
#'
#' @docType data
#' @keywords OfficialName
#'
"new_cnames"

#'hiv.iso: the 17 hiv isos
#'
#' @docType data
#' @keywords iso
#'
"hiv.iso"

#' final_dir_list: saved dir list of final results, could also be obtained using
#' `load.final_dir()`
#'
#' @docType data
#' @keywords directory
#'
"final_dir_list"

#'Rates_Deaths_Country_Summary_2019_UI: The 2019 final estimates with UI
#'
#'Please refer to childmortality.org for details
#'
#' @docType data
#' @keywords dataset
"Rates_Deaths_Country_Summary_2019_UI"


#'Rates_Deaths_Country_Summary_2020_UI: The 2020 final estimates with UI
#'Please refer to childmortality.org for details
#'
#' @docType data
#' @keywords dataset
"Rates_Deaths_Country_Summary_2020_UI"


#' some pre-stored labels, will update from time to time
#' @docType data
#' @keywords labels
"default_label_1"
