# Generated by using Rcpp::compileAttributes() -> do not edit by hand
# Generator token: 10BE3573-1514-4C36-9D1C-5A225CD40393

#' @title GSL Hypergeom 2f0 for equal length vectors
#'
#' @param vA Vector of values for parameter a
#' @param vB Vector of values for parameter b
#' @param vZ Vector of values for parameter z
#'
#' @description Calculate the hypergeometric 2f0 using the GSL library (gsl_sf_hyperg_2F0_e)
#' @return List with vector of values and vector of gsl status codes
#' @keywords internal
vec_gsl_hyp2f0_e <- function(vA, vB, vZ) {
    .Call(`_CLVTools_vec_gsl_hyp2f0_e`, vA, vB, vZ)
}

#' @title GSL Hypergeom 2f1 for equal length vectors
#'
#' @param vA Vector of values for parameter a
#' @param vB Vector of values for parameter b
#' @param vC Vector of values for parameter c
#' @param vZ Vector of values for parameter z
#'
#' @description Calculate the hypergeometric 2f1 using the GSL library (gsl_sf_hyperg_2F1_e)
#' @return List with vector of values and vector of gsl status codes
#' @keywords internal
vec_gsl_hyp2f1_e <- function(vA, vB, vC, vZ) {
    .Call(`_CLVTools_vec_gsl_hyp2f1_e`, vA, vB, vC, vZ)
}

#' @title Gamma-Gamma: Log-Likelihood Function
#'
#' @description
#' Calculates the Log-Likelihood value for the Gamma-Gamma model.
#'
#' @param vLogparams a vector containing the log of the parameters p, q, gamma
#' @param vX frequency vector of length n counting the numbers of purchases
#' @param vM_x the observed average spending for every customer during the calibration time.
#'
#' @details
#' \code{vLogparams} is a vector with the parameters for the Gamma-Gamma model.
#' It has three parameters (p, q, gamma). The scale parameter for each transaction
#' is distributed across customers according to a gamma distribution with
#' parameters q (shape) and gamma (scale).
#'
#'@return
#' Returns the Log-Likelihood value for the Gamma-Gamma model.
#'
#' @template template_rcpp_gg_reference
#'
#'
gg_LL <- function(vLogparams, vX, vM_x) {
    .Call(`_CLVTools_gg_LL`, vLogparams, vX, vM_x)
}

#' @name pnbd_CET
#' @keywords internal
#'
#' @title Pareto/NBD: Conditional Expected Transactions
#'
#' @description
#' Calculates the expected number of transactions in a given time period based
#' on a customer's past transaction behavior and the Pareto/NBD model parameters.
#'
#' \itemize{
#' \item{\code{pnbd_nocov_CET}}{ Conditional Expected Transactions without covariates}
#' \item{\code{pnbd_staticcov_CET}}{ Conditional Expected Transactions with static covariates}
#' }
#'
#'
#' @template template_params_rcppestimatedparams
#' @param dPrediction_period time prediction time frame
#' @template template_params_rcppxtxtcal
#' @template template_params_rcppcovmatrix
#' @template template_params_rcppvcovparams
#'
#'
#' @details
#' \code{vEstimated_params} vector with the estimated parameters in original scale
#' for the Pareto/NBD model, namely (r, alpha, s, beta).
#' r and alpha: unobserved parameters that describe the NBD transaction process.
#' s and beta: unobserved parameters that describe the pareto
#' (exponential gamma) dropout process.
#'
#' \code{mCov_trans} is a matrix containing the covariates data of
#' the time-invariant covariates that affect the transaction process.
#' Each column represents a different covariate. For every column a gamma parameter
#' needs to added to \code{vCovParams_trans} at the respective position.
#'
#' \code{mCov_life} is a matrix containing the covariates data of
#' the time-invariant covariates that affect the lifetime process.
#' Each column represents a different covariate. For every column a gamma parameter
#' needs to added to \code{vCovParams_life} at the respective position.
#'
#'
#'@return
#' Returns a vector containing the conditional expected transactions for the existing
#' customers in the Pareto/NBD model.
#'
#'@references
#'  Fader, Peter S., and Bruce G.S. Hardie (2005). "A Note on Deriving the
#'  Pareto/NBD Model and Related Expressions.", Web.
#'  \url{http://www.brucehardie.com/notes/008/}.
#'
NULL

#' @rdname pnbd_CET
pnbd_nocov_CET <- function(vEstimated_params, dPrediction_period, vX, vT_x, vT_cal) {
    .Call(`_CLVTools_pnbd_nocov_CET`, vEstimated_params, dPrediction_period, vX, vT_x, vT_cal)
}

#' @rdname pnbd_CET
pnbd_staticcov_CET <- function(vEstimated_params, dPrediction_period, vX, vT_x, vT_cal, vCovParams_trans, vCovParams_life, mCov_trans, mCov_life) {
    .Call(`_CLVTools_pnbd_staticcov_CET`, vEstimated_params, dPrediction_period, vX, vT_x, vT_cal, vCovParams_trans, vCovParams_life, mCov_trans, mCov_life)
}

#' @name pnbd_DERT
#'
#' @title Pareto/NBD: Discounted Expected Residual Transactions
#'
#' @description
#' Calculates the discounted expected residual transactions.
#'
#' \itemize{
#' \item{\code{pnbd_nocov_DERT}}{ Discounted expected residual transactions for the Pareto/NBD model without covariates}
#' \item{\code{pnbd_staticcov_DERT}}{ Discounted expected residual transactions for the Pareto/NBD model with static covariates}
#' }
#'
#' @template template_params_rcppestimatedparams
#' @template template_params_rcppxtxtcal
#' @template template_params_rcppcovmatrix
#' @template template_params_rcppvcovparams
#' @param continuous_discount_factor continuous discount factor to use
#'
#' @details
#'
#' \code{vEstimated_params} vector with the estimated parameters in original scale
#' for the Pareto/NBD model, namely (r, alpha, s, beta). \cr
#' r and alpha: unobserved parameters that describe the NBD transaction process. \cr
#' s and beta: unobserved parameters that describe the pareto
#' (exponential gamma) lifetime process.
#'
#' \code{mCov_trans} is a matrix containing the covariates data of
#' the time-invariant covariates that affect the transaction process.
#' Each column represents a different covariate. For every column a gamma parameter
#' needs to added to \code{vCovParams_trans} at the respective position.
#'
#' \code{mCov_life} is a matrix containing the covariates data of
#' the time-invariant covariates that affect the lifetime process.
#' Each column represents a different covariate. For every column a gamma parameter
#' needs to added to \code{vCovParams_life} at the respective position.
#'
#' @return
#' Returns a vector with the DERT for each customer.
#'
#' @references
#' Fader, Peter S., and Bruce G.S. Hardie (2005). "A Note on Deriving the
#' Pareto/NBD Model and Related Expressions.", Web.
#' \url{http://www.brucehardie.com/notes/008/}.
#'
#'
NULL

#' @rdname pnbd_DERT
pnbd_nocov_DERT <- function(vEstimated_params, continuous_discount_factor, vX, vT_x, vT_cal) {
    .Call(`_CLVTools_pnbd_nocov_DERT`, vEstimated_params, continuous_discount_factor, vX, vT_x, vT_cal)
}

#' @rdname pnbd_DERT
pnbd_staticcov_DERT <- function(vEstimated_params, continuous_discount_factor, vX, vT_x, vT_cal, mCov_life, mCov_trans, vCovParams_life, vCovParams_trans) {
    .Call(`_CLVTools_pnbd_staticcov_DERT`, vEstimated_params, continuous_discount_factor, vX, vT_x, vT_cal, mCov_life, mCov_trans, vCovParams_life, vCovParams_trans)
}

#' @name pnbd_LL
#'
#' @title Pareto/NBD: Log-Likelihood
#'
#' @description
#' Calculates the Log-Likelihood values for the Pareto/NBD model with and without covariates.
#'
#' The function \code{pnbd_nocov_LL_ind} calculates the individual LogLikelihood
#' values for each customer for the given parameters.
#'
#' The function \code{pnbd_nocov_LL_sum} calculates the LogLikelihood value summed
#' across customers for the given parameters.
#'
#' The function \code{pnbd_staticcov_LL_ind} calculates the individual LogLikelihood
#' values for each customer for the given parameters and covariates.
#'
#' The function \code{pnbd_staticcov_LL_sum} calculates the individual LogLikelihood values summed
#' across customers.
#'
#' @param vLogparams vector with the Pareto/NBD model parameters log scaled. See Details.
#' @template template_params_rcppxtxtcal
#' @param vParams vector with the parameters for the Pareto/NBD model and the static covariates. See Details.
#' @template template_params_rcppcovmatrix
#'
#' @details
#'
#' \code{r, alpha_0, s, beta_0} are the model parameters used for estimation.\cr
#' s: shape parameter of the Gamma distribution for the lifetime process.
#' The smaller s, the stronger the heterogeneity of customer lifetimes. \cr
#' beta: scale parameter for the Gamma distribution for the lifetime process. \cr
#' r: shape parameter of the Gamma distribution of the purchase process.
#' The smaller r, the stronger the heterogeneity of the purchase process.\cr
#' alpha: scale parameter of the Gamma distribution of the purchase process.
#'
#' \code{vParams} is vector with the Pareto/NBD model parameters at log scale,
#' followed by the parameters for the lifetime covariates at original scale and then
#' followed by the parameters for the transaction covariates at original scale
#'
#' \code{mCov_life} is a matrix containing the covariates data of
#' the time-invariant covariates that affect the lifetime process.
#' Each column represents a different covariate. For every column, a gamma parameter
#' needs to added to \code{vParams} at the respective position.
#'
#' \code{mCov_trans} is a matrix containing the covariates data of
#' the time-invariant covariates that affect the transaction process.
#' Each column represents a different covariate. For every column, a gamma parameter
#' needs to added to \code{vParams} at the respective position.
#'
#'@return
#'  Returns the respective Log-Likelihood value(s) for the Pareto/NBD model
#'  with or without covariates.
#'
#'@references
#'  Fader, Peter S., and Bruce G.S. Hardie (2005). "A Note on Deriving the
#'  Pareto/NBD Model and Related Expressions.", Web.
#'  \url{http://www.brucehardie.com/notes/008/}.
#'
NULL

#' @rdname pnbd_LL
pnbd_nocov_LL_ind <- function(vLogparams, vX, vT_x, vT_cal) {
    .Call(`_CLVTools_pnbd_nocov_LL_ind`, vLogparams, vX, vT_x, vT_cal)
}

#' @rdname pnbd_LL
pnbd_nocov_LL_sum <- function(vLogparams, vX, vT_x, vT_cal) {
    .Call(`_CLVTools_pnbd_nocov_LL_sum`, vLogparams, vX, vT_x, vT_cal)
}

#' @rdname pnbd_LL
pnbd_staticcov_LL_ind <- function(vParams, vX, vT_x, vT_cal, mCov_life, mCov_trans) {
    .Call(`_CLVTools_pnbd_staticcov_LL_ind`, vParams, vX, vT_x, vT_cal, mCov_life, mCov_trans)
}

#' @rdname pnbd_LL
pnbd_staticcov_LL_sum <- function(vParams, vX, vT_x, vT_cal, mCov_life, mCov_trans) {
    .Call(`_CLVTools_pnbd_staticcov_LL_sum`, vParams, vX, vT_x, vT_cal, mCov_life, mCov_trans)
}

#' @name pnbd_PAlive
#'
#' @title Pareto/NBD: Probability of Being Alive
#'
#' @description
#' Calculates the probability of a customer being alive at the end of the calibration period.
#'
#' \itemize{
#' \item{\code{pnbd_nocov_PAlive}}{ P(alive) for the Pareto/NBD model without covariates}
#' \item{\code{pnbd_staticcov_PAlive}}{ P(alive) for the Pareto/NBD model with static covariates}
#' }
#'
#' @template template_params_rcppestimatedparams
#' @template template_params_rcppxtxtcal
#' @template template_params_rcppcovmatrix
#' @template template_params_rcppvcovparams
#'
#' @details
#' \code{vEstimated_params} vector with the estimated parameters in original scale
#' for the Pareto/NBD model, namely (r, alpha, s, beta). \cr
#' r and alpha: unobserved parameters that describe the NBD transaction process. \cr
#' s and beta: unobserved parameters that describe the pareto
#' (exponential gamma) lifetime process.
#'
#' \code{mCov_trans} is a matrix containing the covariates data of
#' the time-invariant covariates that affect the transaction process.
#' Each column represents a different covariate. For every column a gamma parameter
#' needs to added to \code{vCovParams_trans} at the respective position.
#'
#' \code{mCov_life} is a matrix containing the covariates data of
#' the time-invariant covariates that affect the lifetime process.
#' Each column represents a different covariate. For every column a gamma parameter
#' needs to added to \code{vCovParams_life} at the respective position.
#'
#'
#'@return
#'Returns a vector with the PAlive for each customer.
#'
#'@references
#'  Fader, Peter S., and Bruce G.S. Hardie (2005). "A Note on Deriving the
#'  Pareto/NBD Model and Related Expressions.", Web.
#'  \url{http://www.brucehardie.com/notes/008/}.
#'
NULL

#' @rdname pnbd_PAlive
pnbd_nocov_PAlive <- function(vEstimated_params, vX, vT_x, vT_cal) {
    .Call(`_CLVTools_pnbd_nocov_PAlive`, vEstimated_params, vX, vT_x, vT_cal)
}

#' @rdname pnbd_PAlive
pnbd_staticcov_PAlive <- function(vEstimated_params, vX, vT_x, vT_cal, vCovParams_trans, vCovParams_life, mCov_trans, mCov_life) {
    .Call(`_CLVTools_pnbd_staticcov_PAlive`, vEstimated_params, vX, vT_x, vT_cal, vCovParams_trans, vCovParams_life, mCov_trans, mCov_life)
}

