% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/utilities.r
\name{VarCorr}
\alias{VarCorr}
\alias{VarCorr.summary.clme}
\alias{VarCorr.clme}
\title{Variance components}
\usage{
VarCorr(x, sigma, rdig)

\method{VarCorr}{summary.clme}(x, sigma, rdig)

\method{VarCorr}{clme}(x, sigma, rdig)
}
\arguments{
\item{x}{object of class \code{\link{summary.clme}}.}

\item{sigma}{(unused at present).}

\item{rdig}{number of digits to round to (unused at present).}
}
\value{
Numeric.
}
\description{
Variance components

Variance components

Extracts variance components for objects of class \code{clme}.
}
\examples{

data( rat.blood )
cons <- list(order = "simple", decreasing = FALSE, node = 1 )
clme.out <- clme(mcv ~ time + temp + sex + (1|id), data = rat.blood , 
                 constraints = cons, seed = 42, nsim = 0)
                 
VarCorr( clme.out )



}
\seealso{
\code{\link{CLME-package}}
\code{\link{clme}}
}
