% Generated by roxygen2 (4.1.1): do not edit by hand
% Please edit documentation in R/utilities.r
\name{formula.clme}
\alias{formula.clme}
\title{Extract formula}
\usage{
\method{formula}{clme}(x, ...)
}
\arguments{
\item{x}{object of class \code{\link{clme}}.}

\item{...}{space for additional arguments}
}
\value{
Returns a formula object
}
\description{
Extracts the formula from objects of class \code{clme}.
}
\details{
The package \pkg{CLME} parametrizes the model with no intercept term.
If an intercept was included, it will be removed automatically.
}
\examples{
data( rat.blood )
cons <- list(order = "simple", decreasing = FALSE, node = 1 )
clme.out <- clme(mcv ~ time + temp + sex + (1|id), data = rat.blood ,
                 constraints = cons, seed = 42, nsim = 0)

formula( clme.out )
}
\seealso{
\code{\link{CLME-package}}
\code{\link{clme}}
}

