% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/utilities.r
\name{sigma.clme}
\alias{sigma.clme}
\title{Residual variance components}
\usage{
\method{sigma}{clme}(object, ...)
}
\arguments{
\item{object}{object of class \code{\link{clme}}.}

\item{...}{space for additional arguments}
}
\value{
Numeric.
}
\description{
Extract residual variance components for objects of class \code{clme}.
}
\examples{

data( rat.blood )
cons <- list(order = "simple", decreasing = FALSE, node = 1 )
clme.out <- clme(mcv ~ time + temp + sex + (1|id), data = rat.blood , 
                 constraints = cons, seed = 42, nsim = 0)
         
sigma( clme.out )


}
\seealso{
\code{\link{CLME-package}}
\code{\link{clme}}
}
