% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/gg_add_generation_bands.R
\name{gg_add_generation_bands}
\alias{gg_add_generation_bands}
\title{Add bands of transparent colors to denote generations on plots of ancestor-match matrices}
\usage{
gg_add_generation_bands(
  g,
  L,
  alpha = 0.2,
  colors = c("red", "orange", "yellow", "green", "blue"),
  add_impossibles = FALSE
)
}
\arguments{
\item{g}{the original ggplot}

\item{L}{the number of rows (or columns) in the ancestor-match matrices}

\item{alpha}{the transparency to use for these color-bands}

\item{colors}{the colors in order of self, parent, grandparent, etc.  By default it
is just rainbow order starting from red.}

\item{add_impossibles}{pass TRUE if you want to blot out the cells that are not possible
because they conflict with the sex of the individuals.  You set the fill of the
impossibles with a \code{scale_fill_manual()} in the main ggplot call.  i.e.,\preformatted{scale_fill_manual(values = c(`FALSE` = NA, Impossible = "white", `TRUE` = "black"))
}}
}
\description{
Pass it the original ggplot, and this will return it, with the bands added
}
\keyword{internal}
