% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/uneFonction.R
\name{plot.CIps}
\alias{plot.CIps}
\title{Plot method for the CIps class}
\usage{
\method{plot}{CIps}(x, ...)
}
\arguments{
\item{x}{An object of class CIps.}

\item{...}{Additional arguments to be passed to the plot function.}
}
\value{
No return value, called for its side effects, which is plotting a graph.
}
\description{
It provides a ggplot graphic where the x-axis displays all the explanatory variables, with the confidence intervals of the selected variables shown in green and the coefficient estimates represented as red points.
}
\examples{

library(mlbench)
data("BostonHousing")
# lmps object
model = lmps(medv~., data = BostonHousing, method = "Lasso", N = 50)
# CIps object
cips = CIps(model, vote = "coef", alpha = 0.05, s.vote_coef = 0.5)
# plot
plot(cips)

\donttest{
# lmps object
model = lmps(medv~., data = BostonHousing, method = "Lasso", N = 50, cores = 2)
# CIps object
cips = CIps(model, vote = "coef", alpha = 0.05, s.vote_coef = 0.5)
# plot
plot(cips)
}
}
