% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/execquery.R
\name{dbExecQuery}
\alias{dbExecQuery}
\title{Execute a query and free its resources}
\usage{
dbExecQuery(conn, statement, rollbackOnError = FALSE)
}
\arguments{
\item{conn}{a \code{DBI} connection object.}

\item{statement}{a character string with the SQL statement to be executed.}

\item{rollbackOnError}{logical; if \code{TRUE}, then the function executes rollback on current transaction if an exception occurs.}
}
\description{
Executes an SQL query and immediately frees all allocated resources.
}
\details{
This function may be used to execute queries like \code{CREATE TABLE},
\code{UPDATE}, \code{INSERT}, etc.

It has its own exception handler, which prints out detailed information
on caught errors.
}
\seealso{
\code{\link{dbSendQuery}}, \code{\link{dbClearResult}}, \code{\link{dbGetQuery}}
}
