% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/long_est.R
\name{long_est}
\alias{long_est}
\title{Coefficient estimation in the longitudinal model}
\usage{
long_est(
  long_data,
  method,
  id_var,
  outcome_var,
  LM_fixedEffect_variables = NULL,
  time = NULL,
  LM_randomEffect_variables = NULL,
  VPM_variables = NULL,
  imp_time_factor = NULL,
  optCtrl = list(method = "nlminb", kkt = FALSE, tol = 0.2, maxit = 20000),
  control = list(verbose = FALSE, tol = 0.001, GHk = 10, maxiter = 150),
  ...
)
}
\arguments{
\item{long_data}{Longitudinal dataset}

\item{method}{The following methods are available:
\itemize{
\item \code{standard_LME}: Standard linear mixed-effect model.
\item \code{VA_LME}: Linear mixed-effect model adjusted for the historical number of visits.
\item \code{JMVL_LY}: Joint model of the visiting process and the longitudinal process accounting for measured confounders.
\item \code{IIRR_weighting}: Inverse-intensity-rate-ratio weighting approach.
\item \code{JMVL_Liang}: Joint model of the visiting process and the longitudinal process with dependent latent variables.
\item \code{imputation_LME}: Imputation-based approach with linear mixed-effect model.
\item \code{JMVL_G}: Joint model of the visiting process and the longitudinal process with a shared random intercept.
}}

\item{id_var}{Variable for the subject ID to indicate the grouping
structure.}

\item{outcome_var}{Variable name for the longitudinal outcome variable.}

\item{LM_fixedEffect_variables}{Vector input of variable names with fixed
effects in the longitudinal model. Variables should not contain \code{time}.}

\item{time}{Variable for the observational time.}

\item{LM_randomEffect_variables}{Vector input of variable names with random
effects in the longitudinal model. This argument is \code{NULL} for methods
including \code{JMVL_LY}, \code{JMVL_G} and \code{IIRR_weighting}.}

\item{VPM_variables}{Vector input of variable names in the visiting process
model.}

\item{imp_time_factor}{Scale factor for the time variable. This argument is
only needed in the imputation-based methods i.e., \code{imputation_LME}.}

\item{optCtrl}{Control parameters for running the mixed-effect model. See
the \code{control} argument in \code{\link[lme4:lmer]{lme4::lmer()}}.}

\item{control}{Control parameters for the \code{JMVL_G} method:
\itemize{
\item \code{verbose}: \code{TRUE} or \code{FALSE} for outputting checkpoint after each iteration. Default is \code{FALSE}.
\item \code{tol}: Tolerance for convergence.
\item \code{GHk}: Number of gaussian-hermite quadrature points. Default is \code{10}.
\item \code{maxiter}: Maximum number of iteration. Default is \code{150}.
}}

\item{...}{Additional arguments to \code{\link[nleqslv:nleqslv]{nleqslv::nleqslv()}}.}
}
\value{
\code{beta_hat}: Estimated coefficients in the longitudinal model.

Other output in each method:
\itemize{
\item \code{standard_LME}:
\itemize{
\item \code{beta_sd}: Standard deviation of the estimated coefficients.
}
\item \code{VA_LME}:
\itemize{
\item \code{beta_sd}: Standard deviation of the estimated coefficients.
}
\item \code{JMVL_LY}:
\itemize{
\item \code{gamma_hat}: Estimated coefficients in the visiting process model.
}
\item \code{IIRR_weighting}:
\itemize{
\item \code{gamma_hat}: Estimated coefficients in the visiting process model.
}
\item \code{JMVL_Liang}:
\itemize{
\item \code{gamma_hat}: Estimated coefficients in the visiting process model.
}
}
}
\description{
This function offers a collection of methods of coefficient estimation in a
longitudinal model with possibly informative observation time.
These methods include Standard linear mixed-effect model (\code{standard_LME}),
Linear mixed-effect model adjusted for the historical number of visits (\code{VA_LME}),
Joint model of the visiting process and the longitudinal process accounting for measured confounders (\code{JMVL_LY}),
Inverse-intensity-rate-ratio weighting approach (\code{IIRR_weighting}),
Joint model of the visiting process and the longitudinal process with dependent latent variables (\code{JMVL_Liang}),
Imputation-based approach with linear mixed-effect model (\code{imputation_LME}), and
Joint model of the visiting process and the longitudinal process with a shared random intercept (\code{JMVL_G}).
}
\examples{
# Setup arguments
train_data

time_var = "time"
id_var = "id"
outcome_var = "Y"
VPM_variables = c("Z", "X")
LM_fixedEffect_variables = c("Z", "X")
LM_randomEffect_variables = "Z"

# Run the standard LME model
fit_standardLME = long_est(long_data=train_data,
                           method="standard_LME",
                           id_var=id_var,
                           outcome_var=outcome_var,
                           LM_fixedEffect_variables = LM_fixedEffect_variables,
                           time = time_var,
                           LM_randomEffect_variables = LM_randomEffect_variables,
                           VPM_variables = VPM_variables)
# Return the coefficient estimates
fit_standardLME$beta_hat

# Run the VA_LME model
fit_VALME = long_est(long_data=train_data,
                     method="VA_LME",
                     id_var=id_var,
                     outcome_var=outcome_var,
                     LM_fixedEffect_variables = LM_fixedEffect_variables,
                     time = time_var,
                     LM_randomEffect_variables = LM_randomEffect_variables,
                     VPM_variables = VPM_variables)
# Return the coefficient estimates
fit_VALME$beta_hat
}
\references{
Buzkova, P. and Lumley, T. (2007). Longitudinal data analysis for generalized linear models with follow-up dependent
on outcome-related variables. Canadian Journal of Statistics, 35(4):485–500.

Gasparini, A., Abrams, K. R., Barrett, J. K., Major, R. W., Sweeting, M. J., Brunskill, N. J., and Crowther, M. J. (2020).
Mixed-effects models for health care longitudinal data with an informative visiting process: A monte carlo simulation
study. Statistica Neerlandica, 74(1):5–23.

Liang, Y., Lu, W., and Ying, Z. (2009). Joint modeling and analysis of longitudinal data with informative observation
times. Biometrics, 65(2):377–384.

Lin, D. Y. and Ying, Z. (2001). Semiparametric and nonparametric regression analysis of longitudinal data. Journal of
the American Statistical Association, 96(453):103–126.
}
