% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/deriv_functions.R
\name{score_and_hessian_matrix_functions}
\alias{score_and_hessian_matrix_functions}
\alias{deriv_obj}
\alias{scores}
\alias{hessian}
\title{Score and hessian matrix based on the estimating functions.}
\usage{
deriv_obj(setting = "GLM", logL1 = NULL, logL2 = NULL, Y = NULL,
  X = NULL, K = NULL, L = NULL, C = NULL, estimates = NULL)

scores(derivobj = NULL)

hessian(derivobj = NULL)
}
\arguments{
\item{setting}{String with value \code{"GLM"} or \code{"AFT"} indicating
whether the matrices are computed under the GLM or AFT setting.}

\item{logL1}{Expression of the function \code{logL1} generated by
the \code{\link{est_funct_expr}} function.}

\item{logL2}{Expression of the function \code{logL2} generated by
the \code{\link{est_funct_expr}} function.}

\item{Y}{Numeric input vector for the primary outcome.}

\item{X}{Numeric input vector for the exposure variable.}

\item{K}{Numeric input vector for the intermediate outcome.}

\item{L}{Numeric input vector for the observed confounding factor.}

\item{C}{Numeric input vector for the censoring indicator under the AFT setting
(must be coded 0 = censored, 1 = uncensored).}

\item{estimates}{Numeric input vector with point estimates of the parameters
\eqn{\alpha_0, \alpha_1, \alpha_2, \alpha_3, \sigma_1^2,}{\alpha0, \alpha1, \alpha2, \alpha3, \sigma1^2,}
\eqn{\alpha_4, \alpha_{XY}, \sigma_2^2}{\alpha4, \alphaXY, \sigma2^2}
under the GLM setting and of
\eqn{\alpha_0, \alpha_1, \alpha_2, \alpha_3, \sigma_1, \alpha_4, \alpha_{XY}, \sigma_2^2}{\alpha0, \alpha1, \alpha2, \alpha3, \sigma1, \alpha4, \alphaXY, \sigma2^2}
under the AFT setting. Under the AFT setting,
\code{estimates} must also contain the mean of the estimated
true survival times \code{"y_adj_bar"}.}

\item{derivobj}{Output of the \code{\link{deriv_obj}} function used as input in
the \code{\link{scores}} and \code{\link{hessian}} functions.}
}
\value{
The \code{\link{deriv_obj}} function returns a list with
        objects \code{logL1_deriv}, \code{logL2_deriv} which
        contain the score and hessian matrices based on \code{logL1},
        \code{logL2}, respectively.

The \code{\link{scores}} function returns the \eqn{(n \times 8)}{(n x 8)}
        score matrix.

The \code{\link{hessian}} function returns the \eqn{(n \times 8 \times 8)}{(n x 8 x 8)}
        hessian matrix.
}
\description{
Functions to compute the score and hessian matrices of the parameters
based on the estimating functions, under the GLM and AFT setting for
the analysis of a normally-distributed or censored time-to-event
primary outcome. The score and hessian matrices are further used in
the functions \code{\link{sandwich_se}}, \code{\link{ciee}} and
\code{\link{ciee_loop}} to obtain robust sandwich error estimates of the
parameter estimates of
\eqn{\alpha_0, \alpha_1, \alpha_2, \alpha_3, \sigma_1^2, \alpha_4, \alpha_{XY}, \sigma_2^2}{\alpha0, \alpha1, \alpha2, \alpha3, \sigma1^2, \alpha4, \alphaXY, \sigma2^2}
under the GLM setting and
\eqn{\alpha_0, \alpha_1, \alpha_2, \alpha_3, \sigma_1, \alpha_4, \alpha_{XY}, \sigma_2^2}{\alpha0, \alpha1, \alpha2, \alpha3, \sigma1, \alpha4, \alphaXY, \sigma2^2}
under the AFT setting.
}
\details{
For the computation of the score and hessian matrices, first, the help function
\code{\link{deriv_obj}} is used. In a first step, the expression of all first
and second derivatives of the parameters is computed using the expressions of
\code{logL1} and \code{logL2} from the \code{\link{est_funct_expr}} as input.
Then, the numerical values of all first and second derivatives are obtained
for the observed data \code{Y}, \code{X}, \code{K}, \code{L} (and \code{C} under
the AFT setting) and point estimates (\code{estimates}) of the parameters,
for all observed individuals.

Second, the functions \code{\link{scores}} and \code{\link{hessian}} are used
to extract the relevant score and hessian matrices with respect to \code{logL1}
and \code{logL2} from the output of \code{\link{deriv_obj}} and piece them together.
For further details, see the vignette.
}
\examples{

# Generate data including Y, K, L, X under the GLM setting
dat <- generate_data(setting = "GLM")

# Obtain estimating functions' expressions
estfunct <- est_funct_expr(setting = "GLM")

# Obtain point estimates of the parameters
estimates <- get_estimates(setting = "GLM", Y = dat$Y, X = dat$X,
                           K = dat$K, L = dat$L)

# Obtain matrices with all first and second derivatives
derivobj <- deriv_obj(setting = "GLM", logL1 = estfunct$logL1,
                      logL2 = estfunct$logL2, Y = dat$Y, X = dat$X,
                      K = dat$K, L = dat$L, estimates = estimates)
names(derivobj)
head(derivobj$logL1_deriv$gradient)

# Obtain score and hessian matrices
scores(derivobj)
hessian(derivobj)

}
