% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/generate_data.R
\name{generate_data}
\alias{generate_data}
\title{Data generation function}
\usage{
generate_data(setting = "GLM", n = 1000, maf = 0.2, cens = 0.3,
  a = NULL, b = NULL, aXK = 0.2, aXY = 0.1, aXL = 0, aKY = 0.3,
  aLK = 0, aLY = 0, aUY = 0, aUL = 0, mu_X = NULL, sd_X = NULL,
  X_orth_U = TRUE, mu_U = 0, sd_U = 1, mu_K = 0, sd_K = 1, mu_L = 0,
  sd_L = 1, mu_Y = 0, sd_Y = 1)
}
\arguments{
\item{setting}{String with value \code{"GLM"} or \code{"AFT"} indicating
whether the primary outcome is generated as a
normally-distributed quantitative outcome (\code{"GLM"}) or
censored time-to-event outcome (\code{"AFT"}).}

\item{n}{Numeric. Sample size.}

\item{maf}{Numeric. Minor allele frequency of the genetic exposure variable.}

\item{cens}{Numeric. Desired percentage of censored individuals and has to be
specified under the AFT setting. Note that the actual censoring
rate is generated through specification of the parameters
\code{a} and \code{b}, and \code{cens} is mostly used as a check
whether the desired censoring rate is obtained through \code{a}
and \code{b} (otherwise, a warning is issued).}

\item{a}{Integer for generating the desired censoring rate under the AFT
setting. Has to be specified under the AFT setting.}

\item{b}{Integer for generating the desired censoring rate under the AFT
setting. Has to be specified under the AFT setting.}

\item{aXK}{Numeric. Size of the effect of \code{X} on \code{K}.}

\item{aXY}{Numeric. Size of the effect of \code{X} on \code{Y}.}

\item{aXL}{Numeric. Size of the effect of \code{X} on \code{L}.}

\item{aKY}{Numeric. Size of the effect of \code{K} on \code{Y}.}

\item{aLK}{Numeric. Size of the effect of \code{L} on \code{K}.}

\item{aLY}{Numeric. Size of the effect of \code{L} on \code{Y}.}

\item{aUY}{Numeric. Size of the effect of \code{U} on \code{Y}.}

\item{aUL}{Numeric. Size of the effect of \code{U} on \code{L}.}

\item{mu_X}{Numeric. Expected value of \code{X}.}

\item{sd_X}{Numeric. Standard deviation of \code{X}.}

\item{X_orth_U}{Logical. Indicator whether \code{X} should be generated
independently of \code{U} (\code{X_orth_U} = \code{TRUE})
or dependent on \code{U} (\code{X_orth_U} = \code{FALSE}).}

\item{mu_U}{Numeric. Expected value of \code{U}.}

\item{sd_U}{Numeric. Standard deviation of \code{U}.}

\item{mu_K}{Numeric. Expected value of \code{K}.}

\item{sd_K}{Numeric. Standard deviation of \code{K}.}

\item{mu_L}{Numeric. Expected value of \code{L}.}

\item{sd_L}{Numeric. Standard deviation of \code{L}.}

\item{mu_Y}{Numeric. Expected value of \code{Y}.}

\item{sd_Y}{Numeric. Standard deviation of \code{Y}.}
}
\value{
A dataframe containing \code{n} observations of the variables \code{Y},
        \code{K}, \code{X}, \code{L}, \code{U}. Under the AFT setting,
        \code{T=exp(Y)} and the censoring indicator \code{C} (0 = censored,
        1 = uncensored) are also computed.
}
\description{
Function to generate data with \code{n} observations of a primary
outcome \code{Y}, secondary outcome \code{K}, exposure \code{X}, and
measured as well as unmeasured confounders \code{L} and \code{U}, where
the primary outcome is a quantitative normally-distributed variable
(\code{setting} = \code{"GLM"}) or censored time-to-event outcome under
an accelerated failure time (AFT) model (\code{setting} = \code{"AFT"}).
Under the AFT setting, the observed time-to-event variable \code{T=exp(Y)}
as well as the censoring indicator \code{C} are also computed. \code{X}
is generated as a genetic exposure variable in the form of a single
nucleotide variant (SNV) in 0-1-2 additive coding with minor allele
frequency \code{maf}. \code{X} can be generated independently of \code{U}
(\code{X_orth_U} = \code{TRUE}) or dependent on \code{U}
(\code{X_orth_U} = \code{FALSE}). For more details regarding the underlying
model, see the vignette.
}
\examples{
# Generate data under the GLM setting with default values
dat_GLM <- generate_data()
head(dat_GLM)

# Generate data under the AFT setting with default values
dat_AFT <- generate_data(setting = "AFT", a = 0.2, b = 4.75)
head(dat_AFT)

}
