% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/ciee.R
\name{ciee}
\alias{ciee}
\alias{ciee_loop}
\title{CIEE: Causal inference based on estimating equations}
\usage{
ciee(setting = "GLM", estimates = c("ee", "mult_reg", "res_reg", "sem"),
  ee_se = c("sandwich"), BS_rep = NULL, Y = NULL, X = NULL, K = NULL,
  L = NULL, C = NULL)

ciee_loop(setting = "GLM", estimates = c("ee", "mult_reg", "res_reg",
  "sem"), ee_se = c("sandwich"), BS_rep = NULL, Y = NULL, X = NULL,
  K = NULL, L = NULL, C = NULL)
}
\arguments{
\item{setting}{String with value \code{"GLM"} or \code{"AFT"} indicating
whether a normally-distributed (\code{"GLM"}) or censored
time-to-event (\code{"AFT"}) primary outcome \code{Y} is
analyzed.}

\item{estimates}{String vector with possible values \code{"ee"}, \code{"mult_reg"},
\code{"res_reg"}, \code{"sem"} indicating which methods
are computed. \code{"ee"} computes CIEE, \code{"mult_reg"}
the traditional multiple regression method, \code{"res_reg"}
the traditional regression of residuals method, and
\code{"sem"} the structural equation modeling approach.
Multiple methods can be specified.}

\item{ee_se}{String with possible values \code{"sandwich"}, \code{"bootstrap"},
\code{"naive"} indicating how the standard error estimates
of the parameter estiamtes are computed for CIEE approach.
\code{"sandwich"} computes the robust sandwich estimates (default,
recommended), \code{"bootstrap"} the bootstrap estimates and
\code{"naive"} the naive unadjusted standard error estimates
(not recommended, only for comparison).
One method has to be specified.}

\item{BS_rep}{Integer indicating the number of bootstrap samples that are
drawn (recommended 1000) if bootstrap standard errors are computed.}

\item{Y}{Numeric input vector for the primary outcome.}

\item{X}{Numeric input vector for the exposure variable if the \code{\link{ciee}}
function is used; or numeric input dataframe containing the exposure
variables as columns if the \code{\link{ciee_loop}} function is used.}

\item{K}{Numeric input vector for the intermediate outcome.}

\item{L}{Numeric input vector for the observed confounding factor.}

\item{C}{Numeric input vector for the censoring indicator under the AFT setting
(must be coded 0 = censored, 1 = uncensored).}
}
\value{
Object of class \code{ciee}, for which the summary function
        \code{\link{summary.ciee}} is implemented.
        \code{\link{ciee}} returns a list containing the point and standard error
        estimates of all parameters as well as p-values from hypothesis tests
        of the absence of effects, for each specified approach.
        \code{\link{ciee_loop}} returns a list containing the point and standard
        error estimates only of the exposure variables as well as p-values from
        hypothesis tests of the absence of effects, for each specified approach.
}
\description{
Functions to perform CIEE under the GLM or AFT setting:
\code{\link{ciee}} obtains point and standard error estimates of all parameter estimates,
and p-values for testing the absence of effects; \code{\link{ciee_loop}} performs
\code{\link{ciee}} in separate analyses of multiple exposure variables with the same
outcome measures and factors ond only returns point estimates, standard error
estimates and p-values for the exposure variables. Both functions can also compute
estimates and p-values from the two traditional regression methods and from the
structural equation modeling method.
}
\details{
For the computation of CIEE, point estimates of the parameters are obtained
using the \code{\link{get_estimates}} function. Robust sandwich (recommended),
bootstrap, or naive standard error estimates of the parameter estimates are
obtained using the \code{\link{sandwich_se}}, \code{\link{bootstrap_se}}
or \code{\link{naive_se}} function. Large-sample Wald-type tests are performed
for testing the absence of effects, using either the robust sandwich or
bootstrap standard errors.

Regarding the traditional regression methods, the multiple regression or
regression of residual approaches can be computed using the
\code{\link{mult_reg}} and \code{\link{res_reg}} functions. Finally, the
structural equation modeling approachcan be performed using the
\code{\link{sem_appl}} function.
}
\examples{

# Generate data under the GLM setting with default values
maf <- 0.2
n <- 100
dat <- generate_data(n = n, maf = maf)
datX <- data.frame(X = dat$X)
names(datX)[1] <- "X1"
# Add 9 more exposure variables names X2, ..., X10 to X
for (i in 2:10){
  X <- stats::rbinom(n, size = 2, prob = maf)
  datX$X <- X
  names(datX)[i] <- paste("X", i, sep="")
}

# Perform analysis of one exposure variable using all four methods
ciee(Y = dat$Y, X = datX$X1, K = dat$K, L = dat$L)

# Perform analysis of all exposure variables only for CIEE
ciee_loop(estimates = "ee", Y = dat$Y, X = datX, K = dat$K, L = dat$L)

}
