% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/plot.CICA.R
\name{plot.CICA}
\alias{plot.CICA}
\title{Plot method for CICA}
\usage{
\method{plot}{CICA}(x, brain = "auto", cluster = 1, ...)
}
\arguments{
\item{x}{Object of \code{class} CICA}

\item{brain}{auto}

\item{cluster}{Components of cluster to plot. Only used when non fMRI related data is used}

\item{...}{other arguments}
}
\description{
Plot method for CICA. This function shows the cluster specific
independent components in an interactive viewer using the papayar package
}
\examples{
\dontrun{
CICA_data <- Sim_CICA(Nr = 15, Q = 5, R = 4, voxels = 100, timepoints = 10,
E = 0.4, overlap = .25, externalscore = TRUE)

multiple_output = CICA(DataList = CICA_data$X, nComp = 2:6, nClus = 1:5,
userGrid = NULL, RanStarts = 30, RatStarts = NULL, pseudo = c(0.1, 0.2),
pseudoFac = 2, userDef = NULL, scalevalue = 1000, center = TRUE,
maxiter = 100, verbose = TRUE, ctol = .000001)

plot(multiple_output$Q_5_R_4, cluster = 2)
}

}
