% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/summury.cfo.R
\name{summary.cfo}
\alias{summary.cfo}
\title{Generate descriptive summary for objects returned by other functions}
\usage{
\method{summary}{cfo}(object, ...)
}
\arguments{
\item{object}{the object returned by other functions.}

\item{...}{ignored arguments}
}
\value{
\code{summary()} prints the objects returned by other functions.
}
\description{
Generate descriptive summary for objects returned by other functions.
}
\note{
In the example, we set \code{nsimu = 5} for testing time considerations. In reality, \code{nsimu}
is typically set to 5000 to ensure the accuracy of the results.
}
\examples{


## settings for 1dCFO
nsimu <- 5; ncohort <- 12; cohortsize <- 3; init.level <- 1
p.true <- c(0.02, 0.05, 0.20, 0.28, 0.34, 0.40, 0.44); target <- 0.2
assess.window <- 3; accrual.rate <- 2; tte.para <- 0.5; accrual.dist <- 'unif'

## summarize the object returned by CFO.next()
decision <- CFO.next(target = 0.2, cys = c(0, 1, 0), cns = c(3, 6, 0), currdose = 3)
summary(decision)

## summarize the object returned by lateonset.next()
enter.times<- c(0, 0.266, 0.638, 1.54, 2.48, 3.14, 3.32, 4.01, 4.39, 5.38, 5.76,
               6.54, 6.66, 6.93, 7.32, 7.65, 8.14, 8.74)
dlt.times<- c(0, 0, 0, 0, 0, 0, 0, 0, 0, 0.995, 0, 0, 0, 0, 0, 0, 0, 2.58)
current.t<- 9.41
doses<-c(1, 1, 1, 2, 2, 2, 3, 3, 3, 4, 4, 4, 3, 3, 3, 4, 4, 4)
decision <- lateonset.next(design = 'f-aCFO', target, p.true, currdose = 4, assess.window,   
               enter.times, dlt.times, current.t, doses)
summary(decision)

## summarize the object returned by CFO.selectmtd()
selmtd <- CFO.selectmtd(target=0.2, npts=c(3,3,27,3,0,0,0), ntox=c(0,0,4,2,0,0,0))
summary(selmtd)

## summarize the object returned by CFO.simu()
aCFOtrial <- CFO.simu(design = 'aCFO', target, p.true, init.level, ncohort, cohortsize, seed = 1)
summary(aCFOtrial)


\donttest{
# This test may take longer than 5 seconds to run
# It is provided for illustration purposes only
# Users can run this code directly

## summarize the object returned by lateonset.simu()
faCFOtrial <- lateonset.simu (design = 'f-aCFO', target, p.true, init.level,  
                ncohort, cohortsize, assess.window, tte.para, accrual.rate, accrual.dist, seed = 1)
summary(faCFOtrial)

## summarize the object returned by CFO.oc()
faCFOoc <- CFO.oc (nsimu, design = 'f-aCFO', target, p.true, init.level, ncohort, cohortsize,
                      assess.window, tte.para, accrual.rate, accrual.dist, seeds = 1:nsimu)
summary(faCFOoc)

## settings for 2dCFO
p.true <- matrix(c(0.05, 0.10, 0.15, 0.30, 0.45,
0.10, 0.15, 0.30, 0.45, 0.55,
0.15, 0.30, 0.45, 0.50, 0.60), 
nrow = 3, ncol = 5, byrow = TRUE)

cns <- matrix(c(3, 3, 0,
                0, 6, 0,
                0, 0, 0), 
              nrow = 3, ncol = 3, byrow = TRUE)
cys <- matrix(c(0, 1, 0,
                0, 2, 0,
                0, 0, 0), 
              nrow = 3, ncol = 3, byrow = TRUE)
currdose <- c(2,3); target <- 0.3; ncohort <- 12; cohortsize <- 3

## summarize the object returned by CFO2d.next()
decision <- CFO2d.next(target, cys, cns, currdose = currdose, seed = 1)
summary(decision)

## summarize the object returned by CFO2d.selectmtd()
ntox <- matrix(c(0, 0, 2, 0, 0, 0, 2, 7, 0, 0, 0, 2, 0, 0, 0), nrow = 3, ncol = 5, byrow = TRUE)
npts <- matrix(c(3, 0, 12, 0, 0, 3, 12, 24, 0, 0, 3, 3, 0, 0, 0), nrow = 3, ncol = 5, byrow = TRUE)
selmtd <- CFO2d.selectmtd(target=0.3, npts=npts, ntox=ntox)
summary(selmtd)

## summarize the object returned by CFO2d.simu()
CFO2dtrial <- CFO2d.simu(target, p.true, init.level = c(1,1), ncohort, cohortsize, seed = 1)
summary(CFO2dtrial)

## summarize the object returned by CFO2d.oc()
CFO2doc <- CFO2d.oc(nsimu = 5, target, p.true, init.level = c(1,1), ncohort, cohortsize, 
                    seeds = 1:5)
summary(CFO2doc)

## summarize the object returned by CFOeff.next()
decision <- CFOeff.next(target=0.4,txs=c(3,1,7,11,26),tys=c(0,0,0,0,6),
              tns= c(6, 3, 12, 17, 36), currdose = 3, mineff = 0.3)
summary(decision)

## summarize the object returned by CFOeff.simu()
target <- 0.30; mineff <- 0.30
prior.para = list(alp.prior = target, bet.prior = 1 - target, 
                  alp.prior.eff = 0.5, bet.prior.eff = 0.5)
p.true=c(0.05, 0.07, 0.1, 0.12, 0.16)
pE.true=c(0.35, 0.45, 0.5, 0.55, 0.75)
result <- CFOeff.simu(target, p.true, pE.true, ncohort, init.level, cohortsize,
                       prior.para, mineff = mineff, seed = 1)
summary(result)

## summarize the object returned by CFOeff.oc()
nsimu = 10
result <- CFOeff.oc(target, p.true, pE.true, prior.para, 
          init.level,cohortsize, ncohort, nsimu, mineff = mineff, seeds = 1:nsimu)
summary(result)
}

}
\author{
Jialu Fang, Wenliang Wang, Ninghao Zhang, and Guosheng Yin
}
