% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/vulnerability_map.R
\name{vulnerability_map}
\alias{vulnerability_map}
\title{Create a vulnerability map}
\usage{
vulnerability_map(vuln)
}
\arguments{
\item{vuln}{Object of class \code{vulnerability}}
}
\value{
RasterLayer of vulnerability values
}
\description{
Extracts a vulnerability map of species habitat from a \code{vulnerability} object.
}
\details{
Note: this is only a convenience function. The \code{\link{vulnerability}}
  function creates a vulnerability map, and \code{vulnerability_map} simply extracts it.
  This is included for consistency with the \code{sensitivity_map} and
  \code{departure_map} functions.
}
\examples{
mod1 <- cnfa(x = climdat.hist, s.dat = ABPR, field = "CODE")
dep <- departure(x = climdat.hist, y = climdat.fut, s.dat = ABPR)
vuln <- vulnerability(cnfa = mod1, dep = dep)
vuln.map <- vulnerability_map(vuln)

}
\seealso{
\code{\link{vulnerability}}, \code{\link{sensitivity_map}}, \code{\link{exposure_map}}
}
