% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/optimEA.R
\name{optimEA}
\alias{optimEA}
\title{Evolutionary Algorithm for Combinatorial Optimization}
\usage{
optimEA(x = NULL, fun, control = list())
}
\arguments{
\item{x}{Optional start individual(s) as a list. If NULL (default), \code{creationFunction} (in \code{control} list) is used to create initial design. 
If \code{x} has less individuals than the population size, creationFunction will fill up the rest.}

\item{fun}{target function to be minimized}

\item{control}{(list), with the options\cr
\code{budget} The limit on number of target function evaluations (stopping criterion) (default: 1000)\cr
\code{popsize} Population size (default: 100)\cr
\code{generations} Number of generations (stopping criterion) (default: Inf)\cr
\code{targetY} Target function value (stopping criterion) (default: -Inf)\cr
\code{vectorized} Boolean. Defines whether target function is vectorized (takes a list of solutions as argument) or not (takes single solution as argument). Default: FALSE\cr
\code{verbosity} Level of text output during run. Defaults to 0, no output.\cr
\code{plotting} Plot optimization progress during run (TRUE) or not (FALSE). Default is FALSE.\cr
\code{archive} Whether to keep all candidate solutions and their fitness in an archive (TRUE) or not (FALSE). Default is TRUE.\cr
\code{recombinationFunction} Function that performs recombination, default: \code{\link{recombinationPermutationCycleCrossover}}, which is cycle crossover for permutations.\cr
\code{recombinationParameters} Parameter list for recombination (e.g., recombinationParameters$recombinationRate => recombination rate, defaults to 0.5). List is passed to recombinationFunction. \cr
\code{mutationFunction} Function that performs mutation, default: \code{\link{mutationPermutationSwap}}, which is swap mutation for permutations.\cr
\code{mutationParameters} Parameter list for mutation (e.g., mutationParameters$mutationRate => mutation rate). List is passed to mutationFunction. Default: empty list.\cr
\code{selection} Selection process: "tournament" (default) or "truncation"\cr
\code{tournamentSize} Tournament size (default: 2)\cr
\code{tournamentProbability} Tournament probability (default: 0.9)\cr
\code{localSearchFunction} If specified, this function is used for a local search step. Default is NULL. \cr
\code{localSearchRate} Specifies on what fraction of the population local search is applied. Default is zero. Maximum is 1 (100 percent).\cr
\code{localSearchSettings} List of settings passed to the local search function control parameter.\cr
\code{stoppingCriterionFunction} Custom additional stopping criterion. Function evaluated on the population, receiving all individuals (list) and their fitness (vector). If the result is FALSE, the algorithm stops.\cr
\code{verbosity} >0 for text output.\cr
\code{creationFunction} Function to create individuals/solutions in search space. Default is a function that creates random permutations of length 6 \cr
\code{duplicateFunction} Function that evaluates a list of solutions for duplicates. Default is the \code{duplicated} function. \cr
\code{duplicateRemoval} If set to "all" and archiving is on, new individuals are compared against the complete archive to avoid duplicates. With "population", this is limited to the current population.}
}
\value{
a list:\cr 	
\code{xbest} best solution found\cr
\code{ybest} fitness of the best solution\cr
\code{x} history of all evaluated solutions\cr
\code{y} corresponding target function values f(x)\cr
\code{count} number of performed target function evaluations 
\code{message} Termination message: Which stopping criterion was reached.
\code{population} Last population
\code{fitness} Fitness of last population
}
\description{
A basic implementation of a simple Evolutionary Algorithm for Combinatorial Optimization. Default evolutionary operators
aim at permutation optimization problems.
}
\examples{
seed=0
#distance
dF <- distancePermutationHamming
#mutation
mF <- mutationPermutationSwap
#recombination
rF <-  recombinationPermutationCycleCrossover 
#creation
cF <- function()sample(5)
#objective function
lF <- landscapeGeneratorUNI(1:5,dF)
#start optimization
set.seed(seed)
res <- optimEA(,lF,list(creationFunction=cF,mutationFunction=mF,recombinationFunction=rF,
	popsize=15,budget=100,targetY=0,verbosity=1,
	vectorized=TRUE)) ##target function is "vectorized", expects list as input
res$xbest 

}
\seealso{
\code{\link{optimCEGO}}, \code{\link{optimRS}}, \code{\link{optim2Opt}}, \code{\link{optimMaxMinDist}}
}

