% Generated by roxygen2 (4.1.0): do not edit by hand
% Please edit documentation in R/distanceBasedLandscapeGenerators.R
\name{landscapeGeneratorUNI}
\alias{landscapeGeneratorUNI}
\title{Unimodal Fitness Landscape}
\usage{
landscapeGeneratorUNI(ref = 1:10, distFun)
}
\arguments{
\item{ref}{Reference individual}

\item{distFun}{Distance function, used to evaluate d(x,ref), where x is an arbitrary new individual}
}
\value{
returns a function. The function can take any type of individual as its input, depending on whether it is suitable for the distance function.
}
\description{
This function generates uni-modal fitness landscapes based on distance measures.
The fitness is the distance to a reference individual. Hence, the reference individual
is the optimum of the landscape.
}
\examples{
fun <- landscapeGeneratorUNI(ref=1:7,distancePermutationCos)
x <- 1:7
fun(x)
x <- 7:1
fun(x)
x <- sample(7)
fun(x)
}
\references{
Moraglio, Alberto, Yong-Hyuk Kim, and Yourim Yoon. "Geometric surrogate-based optimisation for permutation-based problems." Proceedings of the 13th annual conference companion on Genetic and evolutionary computation. ACM, 2011.
}
\seealso{
\code{\link{landscapeGeneratorMUL}}, \code{\link{landscapeGeneratorGaussian}}
}

