% Generated by roxygen2 (4.1.0): do not edit by hand
% Please edit documentation in R/distanceBasedLandscapeGenerators.R
\name{landscapeGeneratorGaussianBuild}
\alias{landscapeGeneratorGaussianBuild}
\title{Gaussian Landscape Core function}
\usage{
landscapeGeneratorGaussianBuild(nGaussian = 10, upper = 1, ratio = 0.2,
  creationFunction)
}
\arguments{
\item{nGaussian}{number of Gaussian components in the landscape. Default is 10.}

\item{upper}{upper limit of the distance function to be used, controls the width of Gaussians (variance). Default is 1.}

\item{ratio}{minimal function value of the local minima. Default is 0.2. (Note: Global minimum will be at zero, local minimal will be in range \code{[ratio;1]})}

\item{creationFunction}{function to randomly generate the centers of the gaussians}
}
\value{
returns a list, with the following items:\cr
\code{centers} samples which are the centers of each Gaussian
\code{covinv} inverse of variance of each Gaussian
\code{opt} value at randomly chosen optimum center
\code{nGauss} number of Gaussian components
}
\description{
Core Gaussian landscape function. Should not be called directly, as it does not contain proper seed handling.
}
\seealso{
\code{\link{landscapeGeneratorGaussian}}
}
\keyword{internal}

