% Generated by roxygen2 (4.1.0): do not edit by hand
% Please edit documentation in R/distanceBasedLandscapeGenerators.R
\name{landscapeGeneratorGaussian}
\alias{landscapeGeneratorGaussian}
\title{Create Gaussian Landscape}
\usage{
landscapeGeneratorGaussian(nGaussian = 10, upper = 1, ratio = 0.2,
  seed = 1, distanceFunction, creationFunction)
}
\arguments{
\item{nGaussian}{number of Gaussian components in the landscape. Default is 10.}

\item{upper}{upper boundary of the \code{distanceFunction}. Controls width of Gaussian components. Default is 1.}

\item{ratio}{minimal function value of the local minima. Default is 0.2. (Note: Global minimum will be at zero, local minimal will be in range \code{[ratio;1]})}

\item{seed}{seed for the random number generator used before creation of the landscape. Generator status will be saved and reset afterwards.}

\item{distanceFunction}{A function of type \code{f(x,y)}, to evaluate distance between to samples in their given representation.}

\item{creationFunction}{function to randomly generate the centers of the Gaussians, in form of their given representation.}
}
\value{
returns a function. The function takes a solution sample (e.g., a permutation, a tree) as input.
The function returns a single scalar value, which is the objective value for the given sample.
}
\description{
This function is loosely based on the Gaussian Landscape Generator by Bo Yuan and Marcus Gallagher.
It creates a Gaussian Landscape every time it is called. This Landscape can be evaluated like a function.
To adapt to combinatorial spaces, the Gaussians are here based on a user-specified distance measure.
Due to the expected nature of combinatorial spaces and their lack of direction, the resulting
Gaussians are much simplified in comparison to the continuous, vector-valued case (e.g., no rotation).
Since the \code{CEGO} package is tailored to minimization, the landscape is inverted.
}
\examples{
#rng seed
seed=101
# distance function
dF <- function(x,y)(sum((x-y)^2)) #sum of squares
#dF <- function(x,y)sqrt(sum((x-y)^2)) #euclidean distance
# creation function
cF <- function()runif(1)
# plot pars
par(mfrow=c(3,1),mar=c(3.5,3.5,0.2,0.2),mgp=c(2,1,0))
## uni modal distance landscape
# set seed
set.seed(seed)
#landscape
lF <- Vectorize(landscapeGeneratorUNI(cF(),dF))
x <- seq(from=-0,by=0.001,to=1)
plot(x,lF(x),type="l")
## multi-modal distance landscape
# set seed
set.seed(seed)
#landscape
lF <- Vectorize(landscapeGeneratorMUL(replicate(5,cF(),FALSE),dF))
x <- seq(from=-0,by=0.001,to=1)
plot(x,lF(x),type="l")
## glg landscape
#landscape
lF <- landscapeGeneratorGaussian(nGaussian=20,upper=1,
ratio=0.8,seed=seed,dF,cF)
x <- seq(from=-0,by=0.001,to=1)
plot(x,lF(x),type="l")
}
\references{
B. Yuan and M. Gallagher (2003) "On Building a Principled Framework for Evaluating and Testing Evolutionary Algorithms: A Continuous Landscape Generator".
In Proceedings of the 2003 Congress on Evolutionary Computation, IEEE, pp. 451-458, Canberra, Australia.
}

