% Generated by roxygen2 (4.1.0): do not edit by hand
% Please edit documentation in R/permutationDistances.r
\name{distancePermutationLCSeq}
\alias{distancePermutationLCSeq}
\title{Longest Common Subsequence Distance for Permutations}
\usage{
distancePermutationLCSeq(x, y)
}
\arguments{
\item{x}{first permutation (integer vector)}

\item{y}{second permutation (integer vector)}
}
\value{
numeric distance value \deqn{d(x,y)}, scaled to values between 0 and 1 (based on the maximum possible distance between two permutations)
}
\description{
Distance of permutations. Based on the longest sequence (breaks allowed) of permutation elements
in increasing order that both permutations have in common.
This distance is also called Ulam's metric and is the same
as the distance measure based on the insert edit-operation (\code{\link{distancePermutationInsert}}). Note, that
the implementations differ. Insert distance scales better for longer permutations, whereas LCSeq is faster for shorter
permutations.
}
\examples{
x <- 1:5
y <- c(1,2,5,3,4)
distancePermutationLCSeq(x,y)
p <- replicate(10,sample(1:5),simplify=FALSE)
distanceMatrix(p,distancePermutationLCSeq)
}
\references{
Hirschberg, Daniel S. "A linear space algorithm for computing maximal common subsequences." Communications of the ACM 18.6 (1975): 341-343.
}

