% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/Authentication.R
\name{GetOAuthToken}
\alias{GetOAuthToken}
\title{Get OAuth token}
\source{
\url{https://documentation.dataspace.copernicus.eu/APIs/SentinelHub/Overview/Authentication.html}
}
\usage{
GetOAuthToken(id, secret, url = getOption("CDSE.auth_url"))
}
\arguments{
\item{id}{character, user OAuth client id}

\item{secret}{character, user OAuth client secret}

\item{url}{character, endpoint for requesting tokens. Default: Copernicus Data Space Ecosystem OAuth endpoint}
}
\value{
Long character string containing the authentication token.
}
\description{
Gets an OAuth authentication token (long character string)
}
\details{
The token can be used in queries requiring the authentication.
}
\examples{
\dontrun{
id <- "..."
secret <- "..."
token <- GetOAuthToken(id = id, secret = secret)
}
}
\seealso{
\code{\link[CDSE]{GetOAuthClient}}
}
