% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/optional_data.R
\name{eunomiaDir}
\alias{eunomiaDir}
\title{Create a copy of a Eunomia dataset}
\usage{
eunomiaDir(
  datasetName = "GiBleed",
  cdmVersion = "5.3",
  pathToData = Sys.getenv("EUNOMIA_DATA_FOLDER"),
  dbms = "duckdb",
  databaseFile = tempfile(fileext = paste0(".", dbms))
)
}
\arguments{
\item{datasetName}{The data set name as found on https://github.com/darwin-eu/EunomiaDatasets. The
data set name corresponds to the folder with the data set ZIP files}

\item{cdmVersion}{The OMOP CDM version. This version will appear in the suffix of the data file,
for example: {datasetName}_{cdmVersion}.zip. Default: '5.3'}

\item{pathToData}{The path where the Eunomia data is stored on the file system., By default the
value of the environment variable "EUNOMIA_DATA_FOLDER" is used.}

\item{dbms}{The database system to use. "sqlite" or "duckdb" (default)}

\item{databaseFile}{The path where the database file will be copied to. By default, the database
will be copied to a temporary folder, and will be deleted at the end of the R
session.}
}
\value{
The file path to the new Eunomia dataset copy
}
\description{
Creates a copy of a Eunomia database, and returns the path to the new database file.
If the dataset does not yet exist on the user's computer it will attempt to download the source data
to the the path defined by the EUNOMIA_DATA_FOLDER environment variable.
}
\examples{
\dontrun{
 conn <- DBI::dbConnect(RSQLite::SQLite(), eunomiaDir("GiBleed"))
 DBI::dbDisconnect(conn)

 conn <- DBI::dbConnect(duckdb::duckdb(), eunomiaDir("GiBleed", dbms = "duckdb"))
 DBI::dbDisconnect(conn, shutdown = TRUE)

 conn <- DatabaseConnector::connect(dbms = "sqlite", server = eunomiaDir("GiBleed"))
 DatabaseConnector::disconnect(conn)
}

}
