% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/CDFtestingSuite.R
\name{diffatQuantile}
\alias{diffatQuantile}
\title{Determine the distance between CDFs at key quantiles.}
\usage{
diffatQuantile(Y, est, quantile = 0.5, ...)
}
\arguments{
\item{Y}{The vector output of a non-differentially private CDF
computation (cumulative count bins).}

\item{est}{The vector output of a differentially private CDF 
computation (cumulative count bins).}

\item{quantile}{A quantile value between 0 and 1, defaults to 0.5
for the median.}

\item{...}{Optionally add additional parameters. This is primarily used to allow automated
execution of varied diagnostic functions.}
}
\value{
The error at the quantile specified by \code{quantile}
}
\description{
Find the error (between 0 and 1) introduced by DP-Noise at a
   given quantile in the CDF
}
\examples{
diffatQuantile(c(.1,.2,.3,.4,.5,.6,.7,.8,.9,1),
    c(.1,.2,.3,.3,.3,.3,.3,.3,.4,1), .05)
}

