% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/SCORE.R
\name{SCORE}
\alias{SCORE}
\title{Spectral Clustering On Ratios-of-Eigenvectors.}
\usage{
SCORE(G, K, itermax = NULL, startn = NULL)
}
\arguments{
\item{G}{A 0/1 adjacency matrix of a connected graph.}

\item{K}{A positive integer, indicating the number of underlying communities in graph \code{G}.}

\item{itermax}{\code{k-means} parameter, indicating the maximum number of
iterations allowed. The default value is 100.}

\item{startn}{\code{k-means} parameter. If centers is a number, how many
random sets should be chosen? The default value is 10.}
}
\value{
A label vector.
}
\description{
Using ratios-of-eigenvectors to detect underlying communities.
}
\details{
\emph{SCORE} is fully established in \emph{Fast community detection by
  SCORE} of Jin (2015). \emph{SCORE} uses the entry-wise ratios between the
  first leading eigenvector and each of the other \eqn{K-1} leading eigenvectors for
  clustering. It is noteworthy that SCORE only works on connected graphs,
  in other words, it does not allow for isolated vertices.
}
\examples{

# Simulate the Network
n = 10; K = 2;
theta = 0.4 + (0.45-0.05)*(seq(1:n)/n)^2; Theta = diag(theta);
P  = matrix(c(0.8, 0.2, 0.2, 0.8), byrow = TRUE, nrow = K)
set.seed(2022)
l = sample(1:K, n, replace=TRUE); # node labels
Pi = matrix(0, n, K) # label matrix
for (k in 1:K){
  Pi[l == k, k] = 1
}
Omega = Theta \%*\% Pi \%*\% P \%*\% t(Pi) \%*\% Theta;
Adj = matrix(runif(n*n, 0, 1), nrow = n);
Adj = Omega - Adj;
Adj = 1*(Adj >= 0)
diag(Adj) = 0
Adj[lower.tri(Adj)] = t(Adj)[lower.tri(Adj)]
library(igraph)
is.igraph(Adj) # [1] FALSE
ix = components(graph.adjacency(Adj))
componentLabel = ix$membership
giantLabel = which(componentLabel == which.max(ix$csize))
Giant = Adj[giantLabel, giantLabel]
SCORE(Giant, 2)

}
\references{
Jin, J. (2015) \emph{Fast community detection by score}.
  \emph{The Annals of Statistics 43 (1),
  57–89}\cr\url{https://projecteuclid.org/euclid.aos/1416322036}\cr
}
