% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/CARS.R
\docType{package}
\name{CARS}
\alias{CARS}
\alias{CARS-package}
\alias{CARS}
\title{The CARS procedure for controlling the false discovery rate}
\usage{
CARS(X, Y, alpha, tau = 0.9, variance)
}
\arguments{
\item{X}{the first matrix or data frame of observation}

\item{Y}{the second matrix or date frame of observation}

\item{alpha}{targeted FDR (false discovery rate) level}

\item{tau}{the threshold for choosing interesting locations for density estimation, default is 0.5}

\item{variance}{for X and Y, default is NULL. If provided, in the form of a m*2 matrix, the columns are representing x and y's variance for each location}
}
\value{
A list containing the following components: 
\item{de}{decision for each location (0 or 1)}
\item{cars}{estimated CARS statistics}
\item{th}{threshold for CARS procedure}
}
\description{
The CARS procedure for controlling the false discovery rate

This function runs the CARS procedure, constructing the auxiliary variables,
computing the test statistics, choosing the cutoff and selecting the locations.
}
\examples{
X <- matrix(rnorm(1000),ncol=5,nrow=200,byrow=TRUE);
Y <- matrix(rep(c(0,3),c(800,200))+rnorm(1000),ncol=5,nrow=200,byrow=TRUE);
CARS(X,Y,0.05,tau=0.9);

}
