% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/BuyseRes-confint.R
\docType{methods}
\name{BuyseRes-confint}
\alias{BuyseRes-confint}
\alias{confing}
\alias{confint,BuyseRes-method}
\title{Confidence Intervals for Model Parameters}
\usage{
\S4method{confint}{BuyseRes}(object,
  statistic = BuyseTest.options()$statistic, conf.level = 0.95,
  alternative = "two.sided", method.boot = "percentile")
}
\arguments{
\item{object}{an \R object of class \code{\linkS4class{BuyseRes}}, i.e., output of \code{\link{BuyseTest}}}

\item{statistic}{[character] the statistic summarizing the pairwise comparison:
\code{"netChance"} displays the net chance in favor of treatment, as described in Buyse (2010) and Peron et al. (2016)),
whereas \code{"winRatio"} displays the win ratio, as described in Wang et al. (2016).}

\item{conf.level}{[numeric] confidence level for the confidence intervals.}

\item{alternative}{[character] the type of alternative hypothesis: \code{"two.sided"}, \code{"greater"}, or \code{"less"}.}

\item{method.boot}{[character] the method used to compute the boostrap confidence intervals and p-values.
Can be \code{"percentile"} for computing the CI using the quantiles of the boostrap distribution or
\code{"gaussian"} for using a Gaussian approximation to compute the CI where the standard error is computed using the bootstrap samples.}
}
\value{
A matrix containing a column for the estimated statstic (over all strata),
the lower bound and upper bound of the confidence intervals, and the associated p-values.
When using resampling methods,
an attribute \code{n.resampling} specified how many samples have been used to compute the confidence intervals and the p-values.
}
\description{
Computes confidence intervals for net chance statistic or the win ratio statisitc.
}
\details{
When using a permutation test, the uncertainty associated with the estimator is computed under the null hypothesis.
Thus the confidence interval may not be valid if the null hypothesis is false. \cr
More precisely, the quantiles of the distribution of the statistic are computed under the null hypothesis and then shifted by the punctual estimate of the statistic.
Therefore it is possible that the limits of the confidence interval
are estimated outside of the interval of definition of the statistic (e.g. outside [-1,1] for the proportion in favor of treatment).
}
\seealso{
\code{\link{BuyseTest}} for performing a generalized pairwise comparison. \cr
\code{\link{BuyseRes-summary}} for a more detailed presentation of the \code{BuyseRes} object.
}
\keyword{BuyseRes-method}
\keyword{confint}
