% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/brundle.R
\name{Brundle}
\alias{Brundle}
\title{Brundle}
\usage{
Brundle(dbaExperiment, dbaControl, jg.treatedCondition, jg.untreatedCondition,
  jg.experimentSampleSheet, jg.controlSampleSheet,
  jg.correctionFactor = FALSE, jg.noBAMs = FALSE)
}
\arguments{
\item{dbaExperiment}{DiffBind object to be normalised}

\item{dbaControl}{DiffBind object of control peaks}

\item{jg.treatedCondition}{Identical to treated condition in the sample sheet.}

\item{jg.untreatedCondition}{Identical to the control condition in the sample sheet.}

\item{jg.experimentSampleSheet}{Filename of samplesheet for experimental peaks}

\item{jg.controlSampleSheet}{Filename of samplesheet for control peaks}

\item{jg.correctionFactor}{Manually specify correction factor.}

\item{jg.noBAMs}{If set to true, correction factor is estimated from the DiffBind object.}
}
\description{
Normalise one DiffBind object to a second control set of peaks.
}
\examples{
data(dbaExperiment,package="Brundle")
data(dbaControl,package="Brundle")
fpath <- system.file("extdata", "samplesheet_SLX14438_hs_ER_DBA.csv",package="Brundle")
jg.ExperimentSampleSheet<-fpath
fpath <- system.file("extdata", "samplesheet_SLX14438_hs_CTCF_DBA.csv",package="Brundle")
jg.ControlSampleSheet<-fpath
Brundle(dbaExperiment,dbaControl,"Fulvestrant","none",
         jg.ExperimentSampleSheet,jg.ControlSampleSheet,jg.noBAMs=TRUE)

}
\keyword{DESeq2}
\keyword{Diffbind}
