% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/overlap_null_distrib.R
\name{overlap_null_distrib}
\alias{overlap_null_distrib}
\title{Null distribution for boundary overlap statistics}
\usage{
overlap_null_distrib(
  x,
  y,
  rand_both,
  x_convert = FALSE,
  y_convert = FALSE,
  x_cat = FALSE,
  y_cat = FALSE,
  threshold = 0.2,
  n_iterations = 10,
  x_model = "random",
  y_model = "random",
  progress = TRUE
)
}
\arguments{
\item{x}{A SpatRaster object. If rand_both = FALSE, only this raster will be modeled.}

\item{y}{A SpatRaster object. If rand_both = FALSE, this raster does not change.}

\item{rand_both}{TRUE if distribution of traits in x and y should be modeled.}

\item{x_convert}{TRUE if x contains numeric trait data that needs to be converted to boundary intensities. default = FALSE.}

\item{y_convert}{TRUE if y contains numeric trait data that needs to be converted to boundary intensities. default = FALSE.}

\item{x_cat}{TRUE if x contains a categorical variable. default = FALSE.}

\item{y_cat}{TRUE if y contains a categorical variable. default = FALSE.}

\item{threshold}{A value between 0 and 1. The proportion of cells to keep as
boundary elements. default = 0.2.}

\item{n_iterations}{An integer indicating the number of iterations for the function. A value of 100 or 1000
is recommended to produce sufficient resolution for downstream statistical tests. default = 10.}

\item{x_model}{Neutral model to use. Options: 'random' (stochastic), 'gaussian' (Gaussian random field),
and 'random_cluster' (modified random clusters method)}

\item{y_model}{Neutral model to use for y.}

\item{progress}{If progress = TRUE (default) a progress bar will be displayed.}
}
\value{
A list of probability distribution functions for boundary overlap statistics.
}
\description{
Creates custom probability distributions for three boundary overlap statistics (directly overlapping
boundary elements, minimum distance between boundary elements in x to y, and minimum distance
between elements in x and y). Given two SpatRaster objects with the same extent, projection, and
resolution, simulates n iterations of random raster surfaces from neutral model(s).
}
\examples{
\donttest{
data(T.cristatus)
T.cristatus <- terra::rast(T.cristatus_matrix, crs = T.cristatus_crs)
terra::ext(T.cristatus) <- T.cristatus_ext

data(grassland)
grassland <- terra::rast(grassland_matrix, crs = grassland_crs)
terra::ext(grassland) <- grassland_ext

Tcrist_ovlp_null <- overlap_null_distrib(T.cristatus, grassland, rand_both = FALSE,
  x_cat = TRUE, n_iterations = 100, x_model = 'random_cluster')
}

}
\references{
Saura, S. & Martínez-Millán, J. (2000). Landscape patterns simulation with a modified random clusters method. Landscape Ecology, 15:661-678.
}
\author{
Amy Luo
}
