% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/parallel_vboot.R
\name{vboot.coxnet}
\alias{vboot.coxnet}
\title{Internal bootstraping validation cox glmnet model}
\usage{
\method{vboot}{coxnet}(fit, x, y, s, nfolds = 5, B = 200,
  cv_replicates = 100, lambda = TRUE, n_cores = max(1,
  parallel::detectCores() - 1))
}
\arguments{
\item{fit}{Object from glmnet fit.}

\item{x}{A matrix of the predictors, each row is an observation vector.}

\item{y}{Should be a two-column matrix with columns named 'time' and 'status' as in 'glmnet'.}

\item{s}{Value of the penalty parameter "lambda" selected from the original 'cv.glmnet'.}

\item{nfolds}{Number of folds for cross validation as in 'cv.glmnet'.}

\item{B}{Number of bootsrap samples.}

\item{cv_replicates}{Number of replicates for the cross-validation step.}

\item{lambda}{By default, the validation is adjusted using 'lambda.1se' which has error within 1 standard error of the best model. If 'FALSE' the 'lambda.min' referered to the lowest CV error will be used.}

\item{n_cores}{number of cores to use in parallel. Default detectCores()-1.}
}
\description{
Validate glmnet cox regression using bootstrap.
}
