% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/RcppExports.R
\name{pfvbm}
\alias{pfvbm}
\title{Probability mass function of a fully-visible Boltzmann machine evaluated for an individual vector.}
\usage{
pfvbm(xval, bvec, Mmat)
}
\arguments{
\item{xval}{Vector of length n containing binary spin variables.}

\item{bvec}{Vector of length n containing real valued bias parameters.}

\item{Mmat}{Symmetric n by n matrix, with zeros along the diagonal, containing the interaction parameters.}
}
\value{
The probability of the random string \code{xval} under a fully-visible Boltzmann machine with bias vector \code{bvec} and interaction matrix \code{Mmat}.
}
\description{
Compute the probability of a string of n>1 binary spin variables (i.e. each element is -1 or 1) arising from a fully-visible Boltzmann machine with some specified bias vector and interaction matrix.
}
\examples{
# Compute the probability of the vector xval=(-1,1,-1), under bvec and Mmat.
xval <- c(-1,1,-1)
bvec <- c(0,0.5,0.25)
Mmat <- matrix(0.1,3,3) - diag(0.1,3,3)
pfvbm(xval,bvec,Mmat)
}
\references{
H.D. Nguyen and I.A. Wood (2016), Asymptotic normality of the maximum pseudolikelihood estimator for fully-visible Boltzmann machines, IEEE Transactions on Neural Networks and Learning Systems, vol. 27, pp. 897-902.
}
\author{
Andrew T. Jones and Hien D. Nguyen
}
