% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/mvnmvnp.R
\name{mvnmvnp}
\alias{mvnmvnp}
\title{Bayesian inference on a mutlivariate normal (MVN) mean with a multivariate normal (MVN) prior}
\usage{
mvnmvnp(y, m0 = 0, V0 = 1, Sigma = NULL)
}
\arguments{
\item{y}{a vector of observations from a MVN distribution with unknown
mean and known variance-covariance.}

\item{m0}{the mean vector of the MVN prior, or a scalar constant so that the prior
vector of length \eqn{k}{k} with the same element repeated k times, e.g. \code{m0 = 0}}

\item{V0}{the variance-covariance matrix of the MVN prior, or the diagonal 
of the variance-covariance matrix of the MVN prior, or a scalar constant, say \eqn{n_0}{n0},  
so the prior is \eqn{n_0\times \mathbf{I}_k}{n0 * I} where \eqn{\mathbf{I}_k}{I} is the \eqn{k}{k} by \eqn{k}{k} identity matrix.}

\item{Sigma}{the known variance covariance matrix of the data. If
this value is NULL, which it is by default, then the sample covariance is used. NOTE:
 if this is the case then the cdf and quantile functions should really be multivariate
 t, but they are not - in which case the results are only (approximately) valid for large samples.}
}
\value{
A list will be returned with the following components: 
\item{mean}{the posterior mean of the MVN posterior distribution}
\item{var}{the posterior variance-covariance matrix of the MVN posterior distribution}
\item{cdf}{a function that will evaluation the posterior cdf at a given point. This function calls \code{mvtnmorm::pmvnorm}.}
\item{quantile}{a function that will find quantiles from the posterior given input probabilities. This function calls \code{mvtnorm::qmvnorm}.}
}
\description{
Evaluates posterior density for \eqn{\mu}{mu}, the mean of a
MVN distribution, with a MVN prior on \eqn{\mu}{mu}
}
\keyword{misc}
